/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionAlterFunction;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterRegionCommand
implements GfshCommand {
    @CliCommand(value={"alter region"}, help="Alter a region with the given path and configuration.")
    @CliMetaData(relatedTopic={"Region"})
    public Result alterRegion(@CliOption(key={"name"}, mandatory=true, help="Name/Path of the region to be altered.") String regionPath, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which the region will be altered.") String[] groups, @CliOption(key={"entry-idle-time-expiration"}, specifiedDefaultValue="-1", help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the idle expiration.") String entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, specifiedDefaultValue="-1", help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the TTL expiration.") String entryExpirationTTLAction, @CliOption(key={"region-idle-time-expiration"}, specifiedDefaultValue="-1", help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the idle expiration.") String regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, specifiedDefaultValue="-1", help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the TTL expiration.") String regionExpirationTTLAction, @CliOption(key={"cache-listener"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") String[] cacheListeners, @CliOption(key={"cache-loader"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") String cacheLoader, @CliOption(key={"cache-writer"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") String cacheWriter, @CliOption(key={"async-event-queue-id"}, specifiedDefaultValue="", help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"gateway-sender-id"}, specifiedDefaultValue="", help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="false", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"eviction-max"}, specifiedDefaultValue="0", help="Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine when to perform its Eviction Action. The unit of the maximum value is determined by the Eviction Algorithm.") Integer evictionMax) {
        CommandResult result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        this.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE, regionPath);
        try {
            RegionFunctionArgs regionFunctionArgs;
            Set<String> cacheListenersSet;
            InternalCache cache = this.getCache();
            if (groups != null) {
                RegionCommandsUtils.validateGroups(cache, groups);
            }
            RegionFunctionArgs.ExpirationAttrs entryIdle = null;
            if (entryExpirationIdleTime != null || entryExpirationIdleTimeAction != null) {
                if (entryExpirationIdleTime != null && entryExpirationIdleTime == -1) {
                    entryExpirationIdleTime = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(entryExpirationIdleTimeAction)) {
                    entryExpirationIdleTimeAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                entryIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_IDLE, entryExpirationIdleTime, entryExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs entryTTL = null;
            if (entryExpirationTTL != null || entryExpirationTTLAction != null) {
                if (entryExpirationTTL != null && entryExpirationTTL == -1) {
                    entryExpirationTTL = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(entryExpirationTTLAction)) {
                    entryExpirationTTLAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                entryTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.ENTRY_TTL, entryExpirationTTL, entryExpirationTTLAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionIdle = null;
            if (regionExpirationIdleTime != null || regionExpirationIdleTimeAction != null) {
                if (regionExpirationIdleTime != null && regionExpirationIdleTime == -1) {
                    regionExpirationIdleTime = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(regionExpirationIdleTimeAction)) {
                    regionExpirationIdleTimeAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                regionIdle = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_IDLE, regionExpirationIdleTime, regionExpirationIdleTimeAction);
            }
            RegionFunctionArgs.ExpirationAttrs regionTTL = null;
            if (regionExpirationTTL != null || regionExpirationTTLAction != null) {
                if (regionExpirationTTL != null && regionExpirationTTL == -1) {
                    regionExpirationTTL = ExpirationAttributes.DEFAULT.getTimeout();
                }
                if ("__DEFAULT__".equals(regionExpirationTTLAction)) {
                    regionExpirationTTLAction = ExpirationAttributes.DEFAULT.getAction().toString();
                }
                regionTTL = new RegionFunctionArgs.ExpirationAttrs(RegionFunctionArgs.ExpirationAttrs.ExpirationFor.REGION_TTL, regionExpirationTTL, regionExpirationTTLAction);
            }
            if ((cacheListenersSet = (regionFunctionArgs = new RegionFunctionArgs(regionPath, null, null, false, null, null, null, entryIdle, entryTTL, regionIdle, regionTTL, null, null, null, null, cacheListeners, cacheLoader = this.convertDefaultValue(cacheLoader, ""), cacheWriter = this.convertDefaultValue(cacheWriter, ""), asyncEventQueueIds, gatewaySenderIds, null, cloningEnabled, null, null, null, null, null, null, null, null, evictionMax, null, null, null, null)).getCacheListeners()) != null && !cacheListenersSet.isEmpty()) {
                for (String cacheListener : cacheListenersSet) {
                    if (RegionCommandsUtils.isClassNameValid(cacheListener)) continue;
                    throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-listener. \"{0}\" is not valid.", new Object[]{cacheListener}));
                }
            }
            if (cacheLoader != null && !RegionCommandsUtils.isClassNameValid(cacheLoader)) {
                throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-loader. \"{0}\" is not valid.", new Object[]{cacheLoader}));
            }
            if (cacheWriter != null && !RegionCommandsUtils.isClassNameValid(cacheWriter)) {
                throw new IllegalArgumentException(CliStrings.format("Specify a valid class name for cache-writer. \"{0}\" is not valid.", new Object[]{cacheWriter}));
            }
            if (evictionMax != null && evictionMax < 0) {
                throw new IllegalArgumentException(CliStrings.format("Specify 0 or a positive integer value for eviction-max.  \"{0}\" is not valid.", new Object[]{evictionMax}));
            }
            Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)new RegionAlterFunction(), (Object)regionFunctionArgs, targetMembers);
            List regionAlterResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult regionAlterResult : regionAlterResults) {
                boolean success = regionAlterResult.isSuccessful();
                tabularResultData.accumulate("Member", regionAlterResult.getMemberIdOrName());
                if (success) {
                    tabularResultData.accumulate("Status", regionAlterResult.getMessage());
                    xmlEntity.set(regionAlterResult.getXmlEntity());
                    continue;
                }
                tabularResultData.accumulate("Status", "ERROR: " + regionAlterResult.getMessage());
                tabularResultData.setStatus(Result.Status.ERROR);
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
        }
        return result;
    }
}

