/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ConfigurePDXCommand
implements GfshCommand {
    @CliCommand(value={"configure pdx"}, help="Configures Geode's Portable Data eXchange for all the cache(s) in the cluster. This command would not take effect on the running members in the system.\n This command persists the pdx configuration in the locator with cluster configuration service. \n This command should be issued before starting any data members.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result configurePDX(@CliOption(key={"read-serialized"}, help="Set to true to have PDX deserialization produce a PdxInstance instead of an instance of the domain class") Boolean readSerialized, @CliOption(key={"ignore-unread-fields"}, help="Control whether pdx ignores fields that were unread during deserialization. The default is to preserve unread fields be including their data during serialization. But if you configure the cache to ignore unread fields then their data will be lost during serialization.You should only set this attribute to true if you know this member will only be reading cache data. In this use case you do not need to pay the cost of preserving the unread fields since you will never be reserializing pdx data.") Boolean ignoreUnreadFields, @CliOption(key={"disk-store"}, specifiedDefaultValue="", help="Named disk store where the PDX type data will be stored") String diskStore, @CliOption(key={"auto-serializable-classes"}, help="the patterns which are matched against domain class names to determine whether they should be serialized, serialization done by the auto-serializer will throw an exception if the object of these classes are not portable to non-java languages") String[] patterns, @CliOption(key={"portable-auto-serializable-classes"}, help="the patterns which are matched against domain class names to determine whether they should be serialized") String[] portablePatterns) {
        CommandResult result;
        try {
            InfoResultData ird = ResultBuilder.createInfoResultData();
            CacheCreation cache = new CacheCreation(true);
            if (portablePatterns != null && portablePatterns.length > 0 && patterns != null && patterns.length > 0) {
                return ResultBuilder.createUserErrorResult("The autoserializer cannot support both portable and non-portable classes at the same time.");
            }
            if (!CliUtil.getAllNormalMembers(CliUtil.getCacheIfExists()).isEmpty()) {
                ird.addLine("The command would only take effect on new data members joining the distributed system. It won't affect the existing data members");
            }
            if (diskStore != null) {
                cache.setPdxPersistent(true);
                ird.addLine("persistent = " + cache.getPdxPersistent());
                if (!diskStore.equals("")) {
                    cache.setPdxDiskStore(diskStore);
                    ird.addLine("disk-store = " + cache.getPdxDiskStore());
                } else {
                    ird.addLine("disk-store = DEFAULT");
                }
            } else {
                cache.setPdxPersistent(CacheConfig.DEFAULT_PDX_PERSISTENT);
                ird.addLine("persistent = " + cache.getPdxPersistent());
            }
            if (readSerialized != null) {
                cache.setPdxReadSerialized(readSerialized);
            } else {
                cache.setPdxReadSerialized(CacheConfig.DEFAULT_PDX_READ_SERIALIZED);
            }
            ird.addLine("read-serialized = " + cache.getPdxReadSerialized());
            if (ignoreUnreadFields != null) {
                cache.setPdxIgnoreUnreadFields(ignoreUnreadFields);
            } else {
                cache.setPdxIgnoreUnreadFields(CacheConfig.DEFAULT_PDX_IGNORE_UNREAD_FIELDS);
            }
            ird.addLine("ignore-unread-fields = " + cache.getPdxIgnoreUnreadFields());
            if (portablePatterns != null) {
                ReflectionBasedAutoSerializer autoSerializer = new ReflectionBasedAutoSerializer(portablePatterns);
                cache.setPdxSerializer(autoSerializer);
                ird.addLine("PDX Serializer " + cache.getPdxSerializer().getClass().getName());
                ird.addLine("Portable classes " + Arrays.toString(portablePatterns));
            }
            if (patterns != null) {
                ReflectionBasedAutoSerializer nonPortableAutoSerializer = new ReflectionBasedAutoSerializer(true, patterns);
                cache.setPdxSerializer(nonPortableAutoSerializer);
                ird.addLine("PDX Serializer : " + cache.getPdxSerializer().getClass().getName());
                ird.addLine("Non portable classes :" + Arrays.toString(patterns));
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            CacheXmlGenerator.generate(cache, printWriter, true, false, false);
            printWriter.close();
            String xmlDefinition = stringWriter.toString();
            XmlEntity xmlEntity = XmlEntity.builder().withType("pdx").withConfig(xmlDefinition).build();
            result = ResultBuilder.buildResult(ird);
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, null));
        }
        catch (Exception e) {
            return ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

