/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.JmxManagerLocatorRequest;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.UserInputProperty;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.web.shell.HttpOperationInvoker;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ConnectCommand
implements GfshCommand {
    static final int CONNECT_LOCATOR_TIMEOUT_MS = 60000;
    private static final UserInputProperty[] USER_INPUT_PROPERTIES = new UserInputProperty[]{UserInputProperty.KEYSTORE, UserInputProperty.KEYSTORE_PASSWORD, UserInputProperty.KEYSTORE_TYPE, UserInputProperty.TRUSTSTORE, UserInputProperty.TRUSTSTORE_PASSWORD, UserInputProperty.TRUSTSTORE_TYPE, UserInputProperty.CIPHERS, UserInputProperty.PROTOCOL, UserInputProperty.COMPONENT};

    @CliCommand(value={"connect"}, help="Connect to a jmx-manager either directly or via a Locator. If connecting via a Locator, and a jmx-manager doesn't already exist, the Locator will start one.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public Result connect(@CliOption(key={"locator"}, unspecifiedDefaultValue="localhost[10334]", optionContext="__locator__", help="Network address of the Locator in the form: host[port].") ConnectionEndpoint locatorEndPoint, @CliOption(key={"jmx-manager"}, optionContext="__jmx-manager__", help="Network address of the jmx-manager in the form: host[port].") ConnectionEndpoint jmxManagerEndPoint, @CliOption(key={"use-http"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Connects to Manager by sending HTTP requests to HTTP service hosting the Management REST API.  You must first 'disconnect' in order to reconnect to the Manager via locator or jmx-manager using JMX.") boolean useHttp, @CliOption(key={"url"}, unspecifiedDefaultValue="http://localhost:7070/geode-mgmt/v1", help="Indicates the base URL to the Manager's HTTP service.  For example: 'http://<host>:<port>/gemfire/v1' Default is 'http://localhost:7070/geode-mgmt/v1'") String url, @CliOption(key={"user"}, help="User name to securely connect to the jmx-manager. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, help="Password to securely connect to the jmx-manager.") String password, @CliOption(key={"key-store"}, help="Java keystore file containing this application's certificate and private key. If the --key-store-password parameter is not specified then it will be prompted for.") String keystore, @CliOption(key={"key-store-password"}, help="Password to access the private key from the keystore file specified by --key-store.") String keystorePassword, @CliOption(key={"trust-store"}, help="Java keystore file containing the collection of CA certificates trusted by this application. If the --trust-store-password parameter is not specified then it will be prompted for.") String truststore, @CliOption(key={"trust-store-password"}, help="Password to unlock the keystore file specified by --trust-store") String truststorePassword, @CliOption(key={"ciphers"}, help="SSL/TLS ciphers used when encrypting the connection. The default is \"any\".") String sslCiphers, @CliOption(key={"protocols"}, help="SSL/TLS protocol versions to enable when encrypting the connection. The default is \"any\".") String sslProtocols, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring gfsh to connect to the Locator/Manager. The file's path can be absolute or relative to gfsh directory.") File gfSecurityPropertiesFile, @CliOption(key={"use-ssl"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to use SSL for communication with Locator and/or JMX Manager. If set to \"true\", \"gfsecurity.properties\" will also be read. SSL Options take precedence over the properties file. If none are specified, defaults will be used. The default value for this options is \"false\".") boolean useSsl, @CliOption(key={"skip-ssl-validation"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="When connecting via HTTP, connects using 1-way SSL validation rather than 2-way SSL validation.") boolean skipSslValidation) {
        Gfsh gfsh = this.getGfsh();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            return ResultBuilder.createInfoResult("Already connected to: " + this.getGfsh().getOperationInvoker().toString());
        }
        Properties gfProperties = this.resolveSslProperties(gfsh, useSsl, null, gfSecurityPropertiesFile, keystore, keystorePassword, null, truststore, truststorePassword, null, sslCiphers, sslProtocols, null);
        if (ConnectCommand.containsSSLConfig(gfProperties) || ConnectCommand.containsLegacySSLConfig(gfProperties)) {
            useSsl = true;
        }
        if (userName != null) {
            gfProperties.setProperty("security-username", userName);
            if (password == null) {
                password = UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh);
            }
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), password);
        }
        Result result = useHttp ? this.httpConnect(gfProperties, url, skipSslValidation) : this.jmxConnect(gfProperties, useSsl, jmxManagerEndPoint, locatorEndPoint, false);
        return result;
    }

    Properties resolveSslProperties(Gfsh gfsh, boolean useSsl, File gfPropertiesFile, File gfSecurityPropertiesFile, String ... sslOptionValues) {
        Properties gfProperties = this.loadProperties(gfPropertiesFile, gfSecurityPropertiesFile);
        if (ConnectCommand.containsLegacySSLConfig(gfProperties)) {
            return gfProperties;
        }
        if (!(useSsl || ConnectCommand.containsSSLConfig(gfProperties) || this.isSslImpliedBySslOptions(sslOptionValues))) {
            return gfProperties;
        }
        for (int i = 0; i < USER_INPUT_PROPERTIES.length; ++i) {
            UserInputProperty userInputProperty = USER_INPUT_PROPERTIES[i];
            String sslOptionValue = null;
            if (sslOptionValues != null && sslOptionValues.length > i) {
                sslOptionValue = sslOptionValues[i];
            }
            String sslConfigValue = gfProperties.getProperty(userInputProperty.getKey());
            if (sslOptionValue != null) {
                gfProperties.setProperty(userInputProperty.getKey(), sslOptionValue);
                continue;
            }
            if (sslConfigValue != null) continue;
            gfProperties.setProperty(userInputProperty.getKey(), userInputProperty.promptForAcceptableValue(gfsh));
        }
        return gfProperties;
    }

    boolean isSslImpliedBySslOptions(String ... sslOptions) {
        return sslOptions != null && Arrays.stream(sslOptions).anyMatch(Objects::nonNull);
    }

    Properties loadProperties(File ... files) {
        Properties properties = new Properties();
        if (files == null) {
            return properties;
        }
        for (File file : files) {
            if (file == null) continue;
            properties.putAll((Map<?, ?>)ConnectCommand.loadPropertiesFromFile(file));
        }
        return properties;
    }

    static boolean containsLegacySSLConfig(Properties properties) {
        return properties.stringPropertyNames().stream().anyMatch(key -> key.startsWith("cluster-ssl") || key.startsWith("jmx-manager-ssl-") || key.startsWith("http-service-ssl-"));
    }

    private static boolean containsSSLConfig(Properties properties) {
        return properties.stringPropertyNames().stream().anyMatch(key -> key.startsWith("ssl-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result httpConnect(Properties gfProperties, String url, boolean skipSslVerification) {
        Gfsh gfsh = this.getGfsh();
        try {
            SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(gfProperties, SecurableCommunicationChannel.WEB);
            if (sslConfig.isEnabled()) {
                this.configureHttpsURLConnection(sslConfig, skipSslVerification);
                if (url.startsWith("http:")) {
                    url = url.replace("http:", "https:");
                }
            }
            HttpOperationInvoker operationInvoker = new HttpOperationInvoker(gfsh, url, gfProperties);
            gfsh.setOperationInvoker((OperationInvoker)operationInvoker);
            LogWrapper.getInstance().info(CliStrings.format("Successfully connected to: {0}", (Object)operationInvoker.toString()));
            Result result = ResultBuilder.createInfoResult(CliStrings.format("Successfully connected to: {0}", (Object)operationInvoker.toString()));
            return result;
        }
        catch (SecurityException | AuthenticationFailedException e) {
            if (gfProperties.containsKey("security-username")) {
                Result result = this.handleException(e);
                return result;
            }
            gfProperties.setProperty(UserInputProperty.USERNAME.getKey(), UserInputProperty.USERNAME.promptForAcceptableValue(gfsh));
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh));
            Result result = this.httpConnect(gfProperties, url, skipSslVerification);
            return result;
        }
        catch (Exception e) {
            Result result = this.handleException(e);
            return result;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result jmxConnect(Properties gfProperties, boolean useSsl, ConnectionEndpoint memberRmiHostPort, ConnectionEndpoint locatorTcpHostPort, boolean retry) {
        ConnectionEndpoint jmxHostPortToConnect = null;
        Gfsh gfsh = this.getGfsh();
        try {
            if (memberRmiHostPort != null) {
                jmxHostPortToConnect = memberRmiHostPort;
            } else {
                if (useSsl) {
                    gfsh.logToFile("use-ssl is set to true. Connecting to Locator via SSL.", null);
                }
                Gfsh.println(CliStrings.format("Connecting to Locator at {0} ..", new Object[]{locatorTcpHostPort.toString(false)}));
                ConnectToLocatorResult connectToLocatorResult = ConnectCommand.connectToLocator(locatorTcpHostPort.getHost(), locatorTcpHostPort.getPort(), 60000, gfProperties);
                jmxHostPortToConnect = connectToLocatorResult.getMemberEndpoint();
                if (useSsl && !connectToLocatorResult.isJmxManagerSslEnabled()) {
                    gfsh.logInfo("use-ssl is set to true. But JMX Manager doesn't support SSL, connecting without SSL.", null);
                    useSsl = false;
                }
            }
            if (useSsl) {
                gfsh.logToFile("Connecting to manager via SSL.", null);
            }
            if (!retry) {
                Gfsh.println(CliStrings.format("Connecting to Manager at {0} ..", new Object[]{jmxHostPortToConnect.toString(false)}));
            }
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            JmxOperationInvoker operationInvoker = new JmxOperationInvoker(jmxHostPortToConnect.getHost(), jmxHostPortToConnect.getPort(), gfProperties);
            gfsh.setOperationInvoker(operationInvoker);
            infoResultData.addLine(CliStrings.format("Successfully connected to: {0}", (Object)jmxHostPortToConnect.toString(false)));
            LogWrapper.getInstance().info(CliStrings.format("Successfully connected to: {0}", (Object)jmxHostPortToConnect.toString(false)));
            CommandResult commandResult = ResultBuilder.buildResult(infoResultData);
            return commandResult;
        }
        catch (SecurityException | AuthenticationFailedException e) {
            if (gfProperties.containsKey("security-username")) {
                Result result = this.handleException((Exception)e, jmxHostPortToConnect);
                return result;
            }
            gfProperties.setProperty(UserInputProperty.USERNAME.getKey(), UserInputProperty.USERNAME.promptForAcceptableValue(gfsh));
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh));
            Result result = this.jmxConnect(gfProperties, useSsl, jmxHostPortToConnect, null, true);
            return result;
        }
        catch (Exception e) {
            Result result = this.handleException(e, jmxHostPortToConnect);
            return result;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
    }

    public static ConnectToLocatorResult connectToLocator(String host, int port, int timeout, Properties props) throws IOException, ClassNotFoundException {
        DSFIDFactory.registerTypes();
        JmxManagerLocatorResponse locatorResponse = JmxManagerLocatorRequest.send(host, port, timeout, props);
        if (StringUtils.isBlank((String)locatorResponse.getHost()) || locatorResponse.getPort() == 0) {
            Throwable locatorResponseException = locatorResponse.getException();
            String exceptionMessage = "Locator could not find a JMX Manager";
            if (locatorResponseException != null) {
                String locatorResponseExceptionMessage = locatorResponseException.getMessage();
                locatorResponseExceptionMessage = StringUtils.isNotBlank((String)locatorResponseExceptionMessage) ? locatorResponseExceptionMessage : locatorResponseException.toString();
                exceptionMessage = "Exception caused JMX Manager startup to fail because: '".concat(locatorResponseExceptionMessage).concat("'");
            }
            throw new IllegalStateException(exceptionMessage, locatorResponseException);
        }
        ConnectionEndpoint memberEndpoint = new ConnectionEndpoint(locatorResponse.getHost(), locatorResponse.getPort());
        String resultMessage = CliStrings.format("Connecting to Manager at {0} ..", (Object)memberEndpoint.toString(false));
        return new ConnectToLocatorResult(memberEndpoint, resultMessage, locatorResponse.isJmxManagerSslEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers(SSLConfig sslConfig) throws Exception {
        KeyManagerFactory keyManagerFactory = null;
        try (FileInputStream keyStoreStream = null;){
            if (StringUtils.isNotBlank((String)sslConfig.getKeystore())) {
                KeyStore clientKeys = KeyStore.getInstance(sslConfig.getKeystoreType());
                keyStoreStream = new FileInputStream(sslConfig.getKeystore());
                clientKeys.load(keyStoreStream, sslConfig.getKeystorePassword().toCharArray());
                keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(clientKeys, sslConfig.getKeystorePassword().toCharArray());
            }
        }
        return keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers(SSLConfig sslConfig, boolean skipSslVerification) throws Exception {
        FileInputStream trustStoreStream = null;
        TrustManagerFactory trustManagerFactory = null;
        if (skipSslVerification) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            return trustAllCerts;
        }
        try {
            if (StringUtils.isNotBlank((String)sslConfig.getTruststore())) {
                KeyStore serverPub = KeyStore.getInstance(sslConfig.getTruststoreType());
                trustStoreStream = new FileInputStream(sslConfig.getTruststore());
                serverPub.load(trustStoreStream, sslConfig.getTruststorePassword().toCharArray());
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(serverPub);
            }
        }
        finally {
            if (trustStoreStream != null) {
                trustStoreStream.close();
            }
        }
        return trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
    }

    private void configureHttpsURLConnection(SSLConfig sslConfig, boolean skipSslVerification) throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers(sslConfig);
        TrustManager[] trustManagers = this.getTrustManagers(sslConfig, skipSslVerification);
        if (skipSslVerification) {
            HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
        }
        SSLContext ssl = SSLContext.getInstance(SSLUtil.getSSLAlgo(SSLUtil.readArray(sslConfig.getProtocols())));
        ssl.init(keyManagers, trustManagers, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(ssl.getSocketFactory());
    }

    private Result handleException(Exception e) {
        return this.handleException(e, e.getMessage());
    }

    private Result handleException(Exception e, String errorMessage) {
        LogWrapper.getInstance().severe(errorMessage, e);
        return ResultBuilder.createConnectionErrorResult(errorMessage);
    }

    private Result handleException(Exception e, ConnectionEndpoint hostPortToConnect) {
        if (hostPortToConnect == null) {
            return this.handleException(e);
        }
        return this.handleException(e, CliStrings.format("Could not connect to : {0}. {1}", hostPortToConnect.toString(false), e.getMessage()));
    }

    private static Properties loadPropertiesFromFile(File propertyFile) {
        try {
            return ConnectCommand.loadPropertiesFromUrl(propertyFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(CliStrings.format("Failed to load configuration properties from pathname (%1$s)!", (Object)propertyFile.getAbsolutePath()), e);
        }
    }

    private static Properties loadPropertiesFromUrl(URL url) {
        Properties properties = new Properties();
        if (url == null) {
            return properties;
        }
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException io) {
            throw new RuntimeException(CliStrings.format("Could not read config from {0}.", (Object)CliUtil.decodeWithDefaultCharSet(url.getPath())), io);
        }
        return properties;
    }
}

