/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.AsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateAsyncEventQueueFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateAsyncEventQueueCommand
implements GfshCommand {
    @CliCommand(value={"create async-event-queue"}, help="Create Async Event Queue.")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result createAsyncEventQueue(@CliOption(key={"id"}, mandatory=true, help="ID of the queue to be created.") String id, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which queue will be created. If no group is specified the queue will be created on all members.") String[] groups, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether this queue is parallel.") Boolean parallel, @CliOption(key={"enable-batch-conflation"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to enable batch conflation.") Boolean enableBatchConflation, @CliOption(key={"batch-size"}, unspecifiedDefaultValue="100", help="Maximum number of events that a batch can contain.") int batchSize, @CliOption(key={"batch-time-interval"}, unspecifiedDefaultValue="1000", help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") int batchTimeInterval, @CliOption(key={"persistent"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether events should be persisted to a disk store.") boolean persistent, @CliOption(key={"disk-store"}, help="Disk store to be used by this queue.") String diskStore, @CliOption(key={"disk-synchronous"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Whether disk writes are synchronous.") Boolean diskSynchronous, @CliOption(key={"forward-expiration-destroy"}, unspecifiedDefaultValue="false", specifiedDefaultValue="false", help="Whether to forward expiration destroy events.") Boolean ignoreEvictionAndExpiration, @CliOption(key={"max-queue-memory"}, unspecifiedDefaultValue="100", help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") int maxQueueMemory, @CliOption(key={"dispatcher-threads"}, unspecifiedDefaultValue="1", help="Number of threads to use for sending events.") Integer dispatcherThreads, @CliOption(key={"order-policy"}, unspecifiedDefaultValue="KEY", help="Policy for dispatching events when --dispatcher-threads is > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") String orderPolicy, @CliOption(key={"gateway-event-filter"}, help="List of fully qualified class names of GatewayEventFilters for this queue.  These classes filter events before dispatching to remote servers.") String[] gatewayEventFilters, @CliOption(key={"gateway-event-substitution-filter"}, help="Fully qualified class name of the GatewayEventSubstitutionFilter for this queue.") String gatewaySubstitutionListener, @CliOption(key={"listener"}, mandatory=true, help="Fully qualified class name of the AsyncEventListener for this queue.") String listener, @CliOption(key={"listener-param"}, help="Parameter name for the AsyncEventListener.  Optionally, parameter names may be followed by # and a value for the parameter.  Example: --listener-param=loadAll --listener-param=maxRead#1024") String[] listenerParamsAndValues) {
        if (persistent) {
            this.getSecurityService().authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        Properties listenerProperties = new Properties();
        try {
            if (listenerParamsAndValues != null) {
                for (String listenerParamsAndValue : listenerParamsAndValues) {
                    int hashPosition = listenerParamsAndValue.indexOf(35);
                    if (hashPosition == -1) {
                        listenerProperties.put(listenerParamsAndValue, "");
                        continue;
                    }
                    listenerProperties.put(listenerParamsAndValue.substring(0, hashPosition), listenerParamsAndValue.substring(hashPosition + 1));
                }
            }
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            AsyncEventQueueFunctionArgs aeqArgs = new AsyncEventQueueFunctionArgs(id, parallel, enableBatchConflation, batchSize, batchTimeInterval, persistent, diskStore, diskSynchronous, maxQueueMemory, dispatcherThreads, orderPolicy, gatewayEventFilters, gatewaySubstitutionListener, listener, listenerProperties, ignoreEvictionAndExpiration);
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CreateAsyncEventQueueFunction(), (Object)aeqArgs, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(result.getXmlEntity());
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("Unable to create async event queue(s).");
            }
            CommandResult result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity.get() != null) {
                this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while creating the queue: {0}", new Object[]{th.getMessage()}));
        }
    }
}

