/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDefinedIndexesFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateDefinedIndexesCommand
implements GfshCommand {
    private static final CreateDefinedIndexesFunction createDefinedIndexesFunction = new CreateDefinedIndexesFunction();

    @CliCommand(value={"create defined indexes"}, help="Creates all the defined indexes.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result createDefinedIndexes(@CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group of members in which the index will be created.") String[] group) {
        CommandResult result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        if (IndexDefinition.indexDefinitions.isEmpty()) {
            InfoResultData infoResult = ResultBuilder.createInfoResultData();
            infoResult.addLine("No indexes defined");
            return ResultBuilder.buildResult(infoResult);
        }
        try {
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)createDefinedIndexesFunction, IndexDefinition.indexDefinitions, targetMembers);
            List funcResults = (List)rc.getResult();
            TreeSet<String> successfulMembers = new TreeSet<String>();
            HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
            for (Object funcResult : funcResults) {
                if (!(funcResult instanceof CliFunctionResult)) continue;
                CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
                if (cliFunctionResult.isSuccessful()) {
                    successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                    if (xmlEntity.get() != null) continue;
                    xmlEntity.set(cliFunctionResult.getXmlEntity());
                    continue;
                }
                String exceptionMessage = cliFunctionResult.getMessage();
                TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
                if (failedMembers == null) {
                    failedMembers = new TreeSet<String>();
                }
                failedMembers.add(cliFunctionResult.getMemberIdOrName());
                indexOpFailMap.put(exceptionMessage, failedMembers);
            }
            if (!successfulMembers.isEmpty()) {
                InfoResultData infoResult = ResultBuilder.createInfoResultData();
                infoResult.addLine("Indexes successfully created. Use list indexes to get details.");
                int num = 0;
                for (String memberId : successfulMembers) {
                    infoResult.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                }
                result = ResultBuilder.buildResult(infoResult);
            } else {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                Set exceptionMessages = indexOpFailMap.keySet();
                for (String exceptionMessage : exceptionMessages) {
                    erd.addLine(exceptionMessage);
                    erd.addLine("Occurred on following members");
                    Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                    int num = 0;
                    for (String memberId : memberIds) {
                        erd.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                    }
                }
                result = ResultBuilder.buildResult(erd);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }
}

