/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"create disk-store"}, help="Create a disk store.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public Result createDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be created.") String name, @CliOption(key={"allow-force-compaction"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to allow manual compaction through the API or command-line tools.") boolean allowForceCompaction, @CliOption(key={"auto-compact"}, specifiedDefaultValue="true", unspecifiedDefaultValue="true", help="Whether to automatically compact a file when it reaches the compaction-threshold.") boolean autoCompact, @CliOption(key={"compaction-threshold"}, unspecifiedDefaultValue="50", help="Percentage of garbage allowed in the file before it is eligible for compaction.") int compactionThreshold, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="1024", help="The largest size, in megabytes, to allow an operation log to become before automatically rolling to a new file.") int maxOplogSize, @CliOption(key={"queue-size"}, unspecifiedDefaultValue="0", help="For asynchronous queueing. The maximum number of operations to allow into the write queue before automatically flushing the queue. The default of 0 indicates no limit.") int queueSize, @CliOption(key={"time-interval"}, unspecifiedDefaultValue="1000", help="For asynchronous queueing. The number of milliseconds that can elapse before data is flushed to disk. Reaching this limit or the queue-size limit causes the queue to flush.") long timeInterval, @CliOption(key={"write-buffer-size"}, unspecifiedDefaultValue="32768", help="Size of the buffer used to write to disk.") int writeBufferSize, @CliOption(key={"dir"}, mandatory=true, help="Directories where the disk store files will be written, the directories will be created if they don't exist.  Optionally, directory names may be followed by # and the maximum number of megabytes that the disk store can use in the directory.  Example: --dir=/data/ds1 --dir=/data/ds2#5000") String[] directoriesAndSizes, @CliOption(key={"group", "groups"}, help="Group(s) of members on which the disk store will be created. If no group is specified the disk store will be created on all members.", optionContext="geode.converter.member.groups") String[] groups, @CliOption(key={"disk-usage-warning-percentage"}, unspecifiedDefaultValue="90", help="Warning percentage for disk volume usage.") float diskUsageWarningPercentage, @CliOption(key={"disk-usage-critical-percentage"}, unspecifiedDefaultValue="99", help="Critical percentage for disk volume usage.") float diskUsageCriticalPercentage) {
        try {
            DiskStoreAttributes diskStoreAttributes = new DiskStoreAttributes();
            diskStoreAttributes.allowForceCompaction = allowForceCompaction;
            diskStoreAttributes.autoCompact = autoCompact;
            diskStoreAttributes.compactionThreshold = compactionThreshold;
            diskStoreAttributes.maxOplogSizeInBytes = maxOplogSize * 0x100000;
            diskStoreAttributes.queueSize = queueSize;
            diskStoreAttributes.timeInterval = timeInterval;
            diskStoreAttributes.writeBufferSize = writeBufferSize;
            File[] directories = new File[directoriesAndSizes.length];
            int[] sizes = new int[directoriesAndSizes.length];
            for (int i = 0; i < directoriesAndSizes.length; ++i) {
                int hashPosition = directoriesAndSizes[i].indexOf(35);
                if (hashPosition == -1) {
                    directories[i] = new File(directoriesAndSizes[i]);
                    sizes[i] = Integer.MAX_VALUE;
                    continue;
                }
                directories[i] = new File(directoriesAndSizes[i].substring(0, hashPosition));
                sizes[i] = Integer.parseInt(directoriesAndSizes[i].substring(hashPosition + 1));
            }
            diskStoreAttributes.diskDirs = directories;
            diskStoreAttributes.diskDirSizes = sizes;
            diskStoreAttributes.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
            diskStoreAttributes.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CreateDiskStoreFunction(), (Object)new Object[]{name, diskStoreAttributes}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(result.getXmlEntity());
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("Unable to create disk store(s).");
            }
            CommandResult result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity.get() != null) {
                this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while creating the disk store: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }
}

