/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverCreateFunction;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateGatewayReceiverCommand
implements GfshCommand {
    @CliCommand(value={"create gateway-receiver"}, help="Create the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result createGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which to create the Gateway Receiver.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member on which to create the Gateway Receiver.") String[] onMember, @CliOption(key={"manual-start"}, help="Whether manual start is to be enabled or the receiver will start automatically after creation.") Boolean manualStart, @CliOption(key={"start-port"}, help="Starting value of the port range from which the GatewayReceiver's port will be chosen.") Integer startPort, @CliOption(key={"end-port"}, help="End value of the port range from which the GatewayReceiver's port will be chosen.") Integer endPort, @CliOption(key={"bind-address"}, help="The IP address or host name that the receiver's socket will listen on for client connections.") String bindAddress, @CliOption(key={"maximum-time-between-pings"}, help="The maximum amount of time between client pings.") Integer maximumTimeBetweenPings, @CliOption(key={"socket-buffer-size"}, help="The buffer size in bytes of the socket connection for this GatewayReceiver.") Integer socketBufferSize, @CliOption(key={"gateway-transport-filter"}, help="The fully qualified class names of GatewayTransportFilters (separated by comma) to be added to the GatewayReceiver. e.g. gateway-transport-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") String[] gatewayTransportFilters, @CliOption(key={"hostname-for-senders"}, help="The host name that server locators will tell GatewaySenders this GatewayReceiver is listening on.") String hostnameForSenders) {
        CommandResult result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        try {
            GatewayReceiverFunctionArgs gatewayReceiverFunctionArgs = new GatewayReceiverFunctionArgs(manualStart, startPort, endPort, bindAddress, socketBufferSize, maximumTimeBetweenPings, gatewayTransportFilters, hostnameForSenders);
            Set<DistributedMember> membersToCreateGatewayReceiverOn = CliUtil.findMembers(onGroups, onMember);
            if (membersToCreateGatewayReceiverOn.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)GatewayReceiverCreateFunction.INSTANCE, (Object)gatewayReceiverFunctionArgs, membersToCreateGatewayReceiverOn);
            List gatewayReceiverCreateResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult gatewayReceiverCreateResult : gatewayReceiverCreateResults) {
                boolean success = gatewayReceiverCreateResult.isSuccessful();
                tabularResultData.accumulate("Member", gatewayReceiverCreateResult.getMemberIdOrName());
                tabularResultData.accumulate("Status", (success ? "" : "ERROR: ") + gatewayReceiverCreateResult.getMessage());
                if (!success || xmlEntity.get() != null) continue;
                xmlEntity.set(gatewayReceiverCreateResult.getXmlEntity());
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), onGroups));
        }
        return result;
    }
}

