/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateIndexFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateIndexCommand
implements GfshCommand {
    private static final CreateIndexFunction createIndexFunction = new CreateIndexFunction();

    @CliCommand(value={"create index"}, help="Create an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the index to create.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type", help="Type of the index. Valid values are: range, key and hash.") String indexType, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group of members in which the index will be created.") String[] group) {
        CommandResult result;
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        try {
            IndexType idxType;
            if ("range".equalsIgnoreCase(indexType)) {
                idxType = IndexType.FUNCTIONAL;
            } else if ("hash".equalsIgnoreCase(indexType)) {
                idxType = IndexType.HASH;
            } else if ("key".equalsIgnoreCase(indexType)) {
                idxType = IndexType.PRIMARY_KEY;
            } else {
                return ResultBuilder.createUserErrorResult("Invalid index type,value must be one of the following: range, key or hash.");
            }
            if (indexName == null || indexName.isEmpty()) {
                return ResultBuilder.createUserErrorResult("Invalid index name");
            }
            if (indexedExpression == null || indexedExpression.isEmpty()) {
                return ResultBuilder.createUserErrorResult("Invalid indexed expression : \"{0}\"");
            }
            if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
                return ResultBuilder.createUserErrorResult("Region not found : \"{0}\"");
            }
            if (!regionPath.startsWith("/")) {
                regionPath = "/" + regionPath;
            }
            IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, idxType);
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)createIndexFunction, (Object)indexInfo, targetMembers);
            List funcResults = (List)rc.getResult();
            TreeSet<String> successfulMembers = new TreeSet<String>();
            HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
            for (Object funcResult : funcResults) {
                if (!(funcResult instanceof CliFunctionResult)) continue;
                CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
                if (cliFunctionResult.isSuccessful()) {
                    successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                    if (xmlEntity.get() != null) continue;
                    xmlEntity.set(cliFunctionResult.getXmlEntity());
                    continue;
                }
                String exceptionMessage = cliFunctionResult.getMessage();
                TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
                if (failedMembers == null) {
                    failedMembers = new TreeSet<String>();
                }
                failedMembers.add(cliFunctionResult.getMemberIdOrName());
                indexOpFailMap.put(exceptionMessage, failedMembers);
            }
            if (!successfulMembers.isEmpty()) {
                InfoResultData infoResult = ResultBuilder.createInfoResultData();
                infoResult.addLine("Index successfully created with following details");
                infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
                infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
                infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
                infoResult.addLine("Members which contain the index");
                int num = 0;
                for (String memberId : successfulMembers) {
                    infoResult.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                }
                result = ResultBuilder.buildResult(infoResult);
            } else {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                erd.addLine(CliStrings.format("Failed to create index \"{0}\" due to following reasons", (Object)indexName));
                Set exceptionMessages = indexOpFailMap.keySet();
                for (String exceptionMessage : exceptionMessages) {
                    erd.addLine(exceptionMessage);
                    erd.addLine("Occurred on following members");
                    Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                    int num = 0;
                    for (String memberId : memberIds) {
                        erd.addLine(CliStrings.format("{0}. {1}", ++num, memberId));
                    }
                }
                result = ResultBuilder.buildResult(erd);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }
}

