/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class DataCommandsUtils {
    static boolean checkResultList(CompositeResultData rebalanceResultData, List resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            for (Object object : resultList) {
                if (object instanceof Exception) {
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Exception)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Throwable)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            LogWrapper.getInstance().info("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            rebalanceResultData.addSection().addData("Rebalancing for member=" + member.getId(), ", resultList is either null or empty");
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    static List<String> tokenize(String str, String separator) {
        StringTokenizer st = new StringTokenizer(str, separator);
        ArrayList<String> rstList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            rstList.add(st.nextToken());
        }
        return rstList;
    }

    static CompositeResultData toCompositeResultData(CompositeResultData rebalanceResultData, ArrayList<String> rstlist, int index, boolean simulate, InternalCache cache) {
        int resultItemCount = 9;
        if (rstlist.size() > resultItemCount && StringUtils.isNotEmpty((String)rstlist.get(resultItemCount))) {
            TabularResultData table1 = rebalanceResultData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(0));
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(rstlist.get(0)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            table1.accumulate("Value", rstlist.get(1));
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(rstlist.get(1)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(2));
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(rstlist.get(2)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(3));
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(rstlist.get(3)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(4));
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(rstlist.get(4)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(5));
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(rstlist.get(5)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(6));
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(rstlist.get(6)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            table1.accumulate("Value", rstlist.get(7));
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(rstlist.get(7)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            table1.accumulate("Value", rstlist.get(8));
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(rstlist.get(8)).append(newLine);
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            for (int i = resultItemCount; i < rstlist.size(); ++i) {
                headerText = headerText + " " + rstlist.get(i);
            }
            table1.setHeader(headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResultData;
    }

    static Result makePresentationResult(DataCommandResult dataResult) {
        if (dataResult != null) {
            return dataResult.toCommandResult();
        }
        return ResultBuilder.createGemFireErrorResult("Error executing data command");
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, InternalCache cache, boolean returnAll) {
        if (StringUtils.isEmpty((String)region)) {
            return null;
        }
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        if (bean == null) {
            bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean("/" + region);
        }
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = cache.getMembers();
        HashSet<DistributedMember> dsMembersWithThisMember = new HashSet<DistributedMember>();
        dsMembersWithThisMember.addAll(dsMembers);
        dsMembersWithThisMember.add(cache.getDistributedSystem().getDistributedMember());
        Iterator it = dsMembersWithThisMember.iterator();
        Set<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        if (membersName.length > 0) {
            while (it.hasNext()) {
                DistributedMember dsmember = (DistributedMember)it.next();
                for (String memberName : membersName) {
                    String name = MBeanJMXAdapter.getMemberNameOrId(dsmember);
                    if (!name.equals(memberName)) continue;
                    DistributedMember member = dsmember;
                    matchedMembers.add(member);
                    if (returnAll) continue;
                    return matchedMembers;
                }
            }
        }
        if (matchedMembers.size() == 0) {
            matchedMembers = CliUtil.getMembersForeRegionViaFunction(cache, region, true);
        }
        return matchedMembers;
    }

    static DataCommandResult callFunctionForRegion(DataCommandRequest request, DataCommandFunction putfn, Set<DistributedMember> members) {
        if (members.size() == 1) {
            DistributedMember member = members.iterator().next();
            ResultCollector collector = FunctionService.onMember(member).setArguments(request).execute(putfn);
            List list = (List)collector.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                DataCommandResult result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            DataCommandResult result = (DataCommandResult)list.get(0);
            result.aggregate(null);
            return result;
        }
        ResultCollector collector = FunctionService.onMembers(members).setArguments(request).execute(putfn);
        List list = (List)collector.getResult();
        DataCommandResult result = null;
        for (Object object : list) {
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            if (result == null) {
                result = (DataCommandResult)object;
                result.aggregate(null);
                continue;
            }
            result.aggregate((DataCommandResult)object);
        }
        return result;
    }

    public static Set<DistributedMember> getQueryRegionsAssociatedMembers(Set<String> regions, InternalCache cache, boolean returnAll) {
        LogWriter logger = cache.getLogger();
        Set<DistributedMember> newMembers = null;
        Iterator<String> iterator = regions.iterator();
        String region = iterator.next();
        Set<DistributedMember> members = DataCommandsUtils.getRegionAssociatedMembers(region, cache, true);
        if (logger.fineEnabled()) {
            logger.fine("Members for region " + region + " Members " + members);
        }
        ArrayList<String> regionAndingList = new ArrayList<String>();
        regionAndingList.add(region);
        if (regions.size() == 1) {
            newMembers = members;
        } else if (CollectionUtils.isNotEmpty(members)) {
            while (iterator.hasNext()) {
                region = iterator.next();
                newMembers = DataCommandsUtils.getRegionAssociatedMembers(region, cache, true);
                if (newMembers == null) {
                    newMembers = new HashSet<DistributedMember>();
                }
                if (logger.fineEnabled()) {
                    logger.fine("Members for region " + region + " Members " + newMembers);
                }
                regionAndingList.add(region);
                newMembers.retainAll(members);
                members = newMembers;
                if (!logger.fineEnabled()) continue;
                logger.fine("Members after anding for regions " + regionAndingList + " List : " + newMembers);
            }
        }
        members = new HashSet<DistributedMember>();
        if (newMembers == null) {
            return members;
        }
        for (DistributedMember newMember : newMembers) {
            members.add(newMember);
            if (returnAll) continue;
            return members;
        }
        return members;
    }
}

