/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.query.IndexType;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DefineIndexCommand
implements GfshCommand {
    @CliCommand(value={"define index"}, help="Define an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result defineIndex(@CliOption(key={"name"}, mandatory=true, help="Define an index that can be used when executing queries.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type", help="Type of the index. Valid values are: range, key and hash.") String indexType) {
        IndexType idxType;
        if ("range".equalsIgnoreCase(indexType)) {
            idxType = IndexType.FUNCTIONAL;
        } else if ("hash".equalsIgnoreCase(indexType)) {
            idxType = IndexType.HASH;
        } else if ("key".equalsIgnoreCase(indexType)) {
            idxType = IndexType.PRIMARY_KEY;
        } else {
            return ResultBuilder.createUserErrorResult("Invalid index type,value must be one of the following: range, key or hash.");
        }
        if (indexName == null || indexName.isEmpty()) {
            return ResultBuilder.createUserErrorResult("Invalid index name");
        }
        if (indexedExpression == null || indexedExpression.isEmpty()) {
            return ResultBuilder.createUserErrorResult("Invalid indexed expression : \"{0}\"");
        }
        if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
            return ResultBuilder.createUserErrorResult("Region not found : \"{0}\"");
        }
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, idxType);
        IndexDefinition.indexDefinitions.add(indexInfo);
        InfoResultData infoResult = ResultBuilder.createInfoResultData();
        infoResult.addLine("Index successfully defined with following details");
        infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
        infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
        infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
        CommandResult result = ResultBuilder.buildResult(infoResult);
        return result;
    }
}

