/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DeployFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DeployCommand
implements GfshCommand {
    private final DeployFunction deployFunction = new DeployFunction();

    @CliCommand(value={"deploy"}, help="Deploy JARs to a member or members.  Only one of either --jar or --dir may be specified.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.DeployCommand$Interceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result deploy(@CliOption(key={"group", "groups"}, help="Group(s) to which the specified JARs will be deployed. If not specified, deploy will occur on all members.", optionContext="geode.converter.member.groups") String[] groups, @CliOption(key={"jar", "jars"}, help="Path of the JAR to deploy.") String[] jars, @CliOption(key={"dir"}, help="Directory from which to deploy the JARs.") String dir) {
        TabularResultData tabularData = ResultBuilder.createTabularResultData();
        byte[][] shellBytesData = CommandExecutionContext.getBytesFromShell();
        String[] jarNames = CliUtil.bytesToNames(shellBytesData);
        byte[][] jarBytes = CliUtil.bytesToData(shellBytesData);
        Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
        if (targetMembers.size() > 0) {
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)this.deployFunction, (Object)new Object[]{jarNames, jarBytes}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)resultCollector.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Deployed JAR", "");
                    tabularData.accumulate("Deployed JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Deployed JAR", strings[i]);
                    tabularData.accumulate("Deployed JAR Location", strings[i + 1]);
                }
            }
        }
        CommandResult result = ResultBuilder.buildResult(tabularData);
        this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addJarsToThisLocator(jarNames, jarBytes, groups));
        return result;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private final DecimalFormat numFormatter = new DecimalFormat("###,##0.00");

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String message;
            FileResult fileResult;
            Object[] jars = (String[])parseResult.getArguments()[1];
            String dir = (String)parseResult.getArguments()[2];
            if (ArrayUtils.isEmpty((Object[])jars) && StringUtils.isBlank((String)dir)) {
                return ResultBuilder.createUserErrorResult("Parameter \"jar\" or \"dir\" is required. Use \"help <command name>\" for assistance.");
            }
            if (ArrayUtils.isNotEmpty((Object[])jars) && StringUtils.isNotBlank((String)dir)) {
                return ResultBuilder.createUserErrorResult("Parameters \"jar\" and \"dir\" can not both be specified.");
            }
            Object[] filesToUpload = jars;
            if (filesToUpload == null) {
                filesToUpload = new String[]{dir};
            }
            try {
                fileResult = new FileResult((String[])filesToUpload);
            }
            catch (FileNotFoundException fnfex) {
                return ResultBuilder.createGemFireErrorResult("'" + Arrays.toString(filesToUpload) + "' not found.");
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult("I/O error when reading jar/dir: " + ioex.getClass().getName() + ": " + ioex.getMessage());
            }
            if (dir != null && this.readYesNo(message = "\nDeploying files: " + fileResult.getFormattedFileList() + "\nTotal file size is: " + this.numFormatter.format((double)fileResult.computeFileSizeTotal() / 1048576.0) + "MB\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultBuilder.createShellClientAbortOperationResult("Aborted deploy of " + Arrays.toString(filesToUpload) + ".");
            }
            return fileResult;
        }
    }
}

