/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyDiskStoreFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"destroy disk-store"}, help="Destroy a disk store, including deleting all files on disk used by the disk store. Data for closed regions previously using the disk store will be lost.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public Result destroyDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store that will be destroyed.") String name, @CliOption(key={"group", "groups"}, help="Group(s) of members on which the disk store will be destroyed. If no group is specified the disk store will be destroyed on all members.", optionContext="geode.converter.member.groups") String[] groups) {
        try {
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new DestroyDiskStoreFunction(), (Object)new Object[]{name}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (result.getMessage() == null) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(result.getXmlEntity());
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No matching disk stores found.");
            }
            CommandResult result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity.get() != null) {
                this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity((XmlEntity)xmlEntity.get(), groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while destroying the disk store: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }
}

