/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.UnregisterFunction;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyFunctionCommand
implements GfshCommand {
    @CliCommand(value={"destroy function"}, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.")
    @CliMetaData(relatedTopic={"Function Execution"}, interceptor="org.apache.geode.management.internal.cli.commands.DestroyFunctionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result destroyFunction(@CliOption(key={"id"}, mandatory=true, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.") String functionId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Groups of members from which this function will be unregistered.") String[] groups, @CliOption(key={"member"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member from which this function will be unregistered.") String memberId) {
        try {
            InternalCache cache = this.getCache();
            HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
            if (groups != null && memberId != null) {
                return ResultBuilder.createUserErrorResult("Provide either --groups or --member");
            }
            if (groups != null && groups.length > 0) {
                for (String grp : groups) {
                    dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
                }
                Result results = this.executeFunction(cache, dsMembers, functionId);
                return results;
            }
            if (memberId != null) {
                dsMembers.add(this.getMember(cache, memberId));
                Result results = this.executeFunction(cache, dsMembers, functionId);
                return results;
            }
            Result results = this.executeFunction(cache, cache.getMembers(), functionId);
            return results;
        }
        catch (Exception e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            return ResultBuilder.buildResult(errorResultData);
        }
    }

    private Result executeFunction(InternalCache cache, Set<DistributedMember> DsMembers, String functionId) {
        ArrayList resultList;
        UnregisterFunction unregisterFunction = new UnregisterFunction();
        FunctionService.registerFunction(unregisterFunction);
        if (DsMembers.isEmpty()) {
            return ResultBuilder.createInfoResult("No members for execution");
        }
        Object[] obj = new Object[]{functionId};
        Execution execution = FunctionService.onMembers(DsMembers).setArguments(obj);
        if (execution == null) {
            cache.getLogger().error("executeUnregister execution is null");
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Cannot execute");
            return ResultBuilder.buildResult(errorResultData);
        }
        try {
            resultList = (ArrayList)execution.execute(unregisterFunction).getResult();
        }
        catch (FunctionException ex) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(ex.getMessage());
            return ResultBuilder.buildResult(errorResultData);
        }
        String resultStr = (String)resultList.get(0);
        if (resultStr.equals("Succeeded in unregistering")) {
            StringBuilder members = new StringBuilder();
            for (DistributedMember member : DsMembers) {
                members.append(member.getId());
                members.append(",");
            }
            return ResultBuilder.createInfoResult("Destroyed " + functionId + " Successfully on " + members.toString().substring(0, members.toString().length() - 1));
        }
        return ResultBuilder.createInfoResult("Failed in unregistering");
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            paramValueMap.entrySet();
            String onGroup = paramValueMap.get("group");
            String onMember = paramValueMap.get("member");
            if (onGroup == null && onMember == null) {
                AbstractCliAroundInterceptor.Response response = this.readYesNo("Do you really want to destroy " + paramValueMap.get("id") + " on entire DS?", AbstractCliAroundInterceptor.Response.NO);
                if (response == AbstractCliAroundInterceptor.Response.NO) {
                    return ResultBuilder.createShellClientAbortOperationResult("Aborted destroy of " + paramValueMap.get("id"));
                }
                return ResultBuilder.createInfoResult("Destroying " + paramValueMap.get("id"));
            }
            return ResultBuilder.createInfoResult("Destroying " + paramValueMap.get("id"));
        }
    }
}

