/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyGatewaySenderCommand
implements GfshCommand {
    @CliCommand(value={"destroy gateway-sender"}, help="Destroy the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result destroyGatewaySender(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which to destroy the Gateway Sender.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member on which to destroy the Gateway Sender.") String[] onMember, @CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid", help="Id of the GatewaySender.") String id) {
        CommandResult result;
        try {
            GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = new GatewaySenderDestroyFunctionArgs(id);
            Set<DistributedMember> membersToDestroyGatewaySenderOn = CliUtil.findMembers(onGroups, onMember);
            if (membersToDestroyGatewaySenderOn.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)GatewaySenderDestroyFunction.INSTANCE, (Object)gatewaySenderDestroyFunctionArgs, membersToDestroyGatewaySenderOn);
            List gatewaySenderDestroyResults = (List)resultCollector.getResult();
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            String errorPrefix = "ERROR: ";
            for (CliFunctionResult gatewaySenderDestroyResult : gatewaySenderDestroyResults) {
                boolean success = gatewaySenderDestroyResult.isSuccessful();
                tabularResultData.accumulate("Member", gatewaySenderDestroyResult.getMemberIdOrName());
                tabularResultData.accumulate("Status", (success ? "" : "ERROR: ") + gatewaySenderDestroyResult.getMessage());
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(e.getMessage());
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        return result;
    }
}

