/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyIndexFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyIndexCommand
implements GfshCommand {
    private static final DestroyIndexFunction destroyIndexFunction = new DestroyIndexFunction();

    @CliCommand(value={"destroy index"}, help="Destroy/Remove the specified index.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result destroyIndex(@CliOption(key={"name"}, unspecifiedDefaultValue="", help="Name of the index to remove.") String indexName, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region from which the index will be removed.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member from which the index will be removed.") String[] memberNameOrID, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group of members from which the index will be removed.") String[] group) {
        CommandResult result;
        if (StringUtils.isBlank((String)indexName) && StringUtils.isBlank((String)regionPath) && ArrayUtils.isEmpty((Object[])group) && ArrayUtils.isEmpty((Object[])memberNameOrID)) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("\"{0}\" requires that one or more parameters be provided.", (Object)"destroy index"));
        }
        Cache cache = CacheFactory.getAnyInstance();
        String regionName = null;
        if (regionPath != null) {
            regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
        }
        IndexInfo indexInfo = new IndexInfo(indexName, regionName);
        Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)destroyIndexFunction, (Object)indexInfo, targetMembers);
        List funcResults = (List)rc.getResult();
        TreeSet<String> successfulMembers = new TreeSet<String>();
        HashMap<String, TreeSet<String>> indexOpFailMap = new HashMap<String, TreeSet<String>>();
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        for (Object funcResult : funcResults) {
            if (!(funcResult instanceof CliFunctionResult)) continue;
            CliFunctionResult cliFunctionResult = (CliFunctionResult)funcResult;
            if (cliFunctionResult.isSuccessful()) {
                successfulMembers.add(cliFunctionResult.getMemberIdOrName());
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(cliFunctionResult.getXmlEntity());
                continue;
            }
            String exceptionMessage = cliFunctionResult.getMessage();
            TreeSet<String> failedMembers = (TreeSet<String>)indexOpFailMap.get(exceptionMessage);
            if (failedMembers == null) {
                failedMembers = new TreeSet<String>();
            }
            failedMembers.add(cliFunctionResult.getMemberIdOrName());
            indexOpFailMap.put(exceptionMessage, failedMembers);
        }
        if (!successfulMembers.isEmpty()) {
            InfoResultData infoResult = ResultBuilder.createInfoResultData();
            if (StringUtils.isNotBlank((String)indexName)) {
                if (StringUtils.isNotBlank((String)regionPath)) {
                    infoResult.addLine(CliStrings.format("Index \"{0}\" on region : \"{1}\" successfully destroyed on the following members", indexName, regionPath));
                } else {
                    infoResult.addLine(CliStrings.format("Index \"{0}\" successfully destroyed on the following members", (Object)indexName));
                }
            } else if (StringUtils.isNotBlank((String)regionPath)) {
                infoResult.addLine(CliStrings.format("Indexes on region : {0} successfully destroyed on the following members", (Object)regionPath));
            } else {
                infoResult.addLine("Indexes successfully destroyed on the following members");
            }
            int num = 0;
            for (String memberId : successfulMembers) {
                infoResult.addLine(CliStrings.format(CliStrings.format("{0}. {1}", ++num, memberId), new Object[0]));
            }
            result = ResultBuilder.buildResult(infoResult);
        } else {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            if (StringUtils.isNotBlank((String)indexName)) {
                erd.addLine(CliStrings.format("Index \"{0}\" could not be destroyed for following reasons", (Object)indexName));
            } else {
                erd.addLine("Indexes could not be destroyed for following reasons");
            }
            Set exceptionMessages = indexOpFailMap.keySet();
            for (String exceptionMessage : exceptionMessages) {
                erd.addLine(CliStrings.format("{0}.", (Object)exceptionMessage));
                erd.addLine("Occurred on following members");
                Set memberIds = (Set)indexOpFailMap.get(exceptionMessage);
                int num = 0;
                for (String memberId : memberIds) {
                    erd.addLine(CliStrings.format(CliStrings.format("{0}. {1}", ++num, memberId), new Object[0]));
                }
                erd.addLine("");
            }
            result = ResultBuilder.buildResult(erd);
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity((XmlEntity)xmlEntity.get(), group));
        }
        return result;
    }
}

