/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.RegionAttributesData;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionDestroyFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyRegionCommand
implements GfshCommand {
    @CliCommand(value={"destroy region"}, help="Destroy/Remove a region.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyRegion(@CliOption(key={"name"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Name/Path of the region to be removed.") String regionPath) {
        Result result;
        if (regionPath == null) {
            return ResultBuilder.createInfoResult("Please specify region path for the region to be destroyed.");
        }
        if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
            return ResultBuilder.createInfoResult(CliStrings.format("Region path \"{0}\" is not valid.", new Object[]{regionPath}));
        }
        AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
        try {
            Set<DistributedMember> regionMembersList;
            InternalCache cache = this.getCache();
            ManagementService managementService = ManagementService.getExistingManagementService(cache);
            String regionPathToUse = regionPath;
            if (!regionPathToUse.startsWith("/")) {
                regionPathToUse = "/" + regionPathToUse;
            }
            if ((regionMembersList = this.findMembersForRegion(cache, managementService, regionPathToUse)).size() == 0) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Could not find a Region with Region path \"{0}\" in this Geode cluster. If region was recently created, please wait for at least {1} to allow the associated Management resources to be federated.", regionPath, "jmx-manager-update-rate milliseconds"));
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)RegionDestroyFunction.INSTANCE, (Object)regionPath, regionMembersList);
            List resultsList = (List)resultCollector.getResult();
            String message = CliStrings.format("\"{0}\" {1} destroyed successfully.", regionPath, "");
            boolean isRegionDestroyed = true;
            for (CliFunctionResult aResultsList : resultsList) {
                CliFunctionResult destroyRegionResult = aResultsList;
                if (destroyRegionResult.isSuccessful()) {
                    xmlEntity.set(destroyRegionResult.getXmlEntity());
                    continue;
                }
                if (destroyRegionResult.getThrowable() != null) {
                    Throwable t = destroyRegionResult.getThrowable();
                    LogWrapper.getInstance().info(t.getMessage(), t);
                    message = CliStrings.format("Error occurred while destroying region \"{0}\". Reason: {1}", regionPath, t.getMessage());
                    isRegionDestroyed = false;
                    continue;
                }
                message = CliStrings.format("Unknown result while destroying region \"{0}\". Reason: {1}", regionPath, destroyRegionResult.getMessage());
                isRegionDestroyed = false;
            }
            result = isRegionDestroyed ? ResultBuilder.createInfoResult(message) : ResultBuilder.createUserErrorResult(message);
        }
        catch (IllegalStateException e) {
            result = ResultBuilder.createUserErrorResult(CliStrings.format("Error while destroying region {0}. Reason: {1}", regionPath, e.getMessage()));
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error while destroying region {0}. Reason: {1}", regionPath, e.getMessage()));
        }
        if (xmlEntity.get() != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity((XmlEntity)xmlEntity.get(), null));
        }
        return result;
    }

    private Set<DistributedMember> findMembersForRegion(InternalCache cache, ManagementService managementService, String regionPath) {
        Set<DistributedMember> membersList = new HashSet<DistributedMember>();
        HashSet<String> regionMemberIds = new HashSet<String>();
        MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
        if (regionPath.contains("-")) {
            regionPath = "\"" + regionPath + "\"";
        }
        String queryExp = MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", regionPath, "*");
        try {
            ObjectName queryExpON = new ObjectName(queryExp);
            Set<ObjectName> queryNames = mbeanServer.queryNames(null, queryExpON);
            if (queryNames == null || queryNames.isEmpty()) {
                return membersList;
            }
            boolean addedOneRemote = false;
            for (ObjectName regionMBeanObjectName : queryNames) {
                try {
                    RegionMXBean regionMXBean = managementService.getMBeanInstance(regionMBeanObjectName, RegionMXBean.class);
                    if (regionMXBean == null) continue;
                    RegionAttributesData regionAttributes = regionMXBean.listRegionAttributes();
                    String scope = regionAttributes.getScope();
                    if (Scope.LOCAL.equals(Scope.fromString(scope))) {
                        regionMemberIds.add(regionMXBean.getMember());
                        continue;
                    }
                    if (addedOneRemote) continue;
                    regionMemberIds.add(regionMXBean.getMember());
                    addedOneRemote = true;
                }
                catch (ClassCastException e) {
                    LogWriter logger = cache.getLogger();
                    if (!logger.finerEnabled()) continue;
                    logger.finer(regionMBeanObjectName + " is not a " + RegionMXBean.class.getSimpleName(), e);
                }
            }
            if (!regionMemberIds.isEmpty()) {
                membersList = this.getMembersByIds(cache, regionMemberIds);
            }
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            LogWrapper.getInstance().info(e.getMessage(), e);
        }
        return membersList;
    }

    private Set<DistributedMember> getMembersByIds(InternalCache cache, Set<String> memberIds) {
        Set<DistributedMember> foundMembers = Collections.emptySet();
        if (memberIds != null && !memberIds.isEmpty()) {
            foundMembers = new HashSet<DistributedMember>();
            Set<DistributedMember> allNormalMembers = CliUtil.getAllNormalMembers(cache);
            for (String memberId : memberIds) {
                for (DistributedMember distributedMember : allNormalMembers) {
                    if (!memberId.equals(distributedMember.getId()) && !memberId.equals(distributedMember.getName())) continue;
                    foundMembers.add(distributedMember);
                }
            }
        }
        return foundMembers;
    }
}

