/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.springframework.shell.core.annotation.CliCommand;

public class DisconnectCommand
implements GfshCommand {
    @CliCommand(value={"disconnect"}, help="Close the current connection, if one is open.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public Result disconnect() {
        Result result;
        if (this.getGfsh() != null && !this.getGfsh().isConnectedAndReady()) {
            result = ResultBuilder.createInfoResult("Not connected.");
        } else {
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            try {
                Gfsh gfshInstance = this.getGfsh();
                if (gfshInstance.isConnectedAndReady()) {
                    OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
                    Gfsh.println("Disconnecting from: " + operationInvoker);
                    operationInvoker.stop();
                    infoResultData.addLine(CliStrings.format("Disconnected from : {0}", (Object)operationInvoker.toString()));
                    LogWrapper.getInstance().info(CliStrings.format("Disconnected from : {0}", (Object)operationInvoker.toString()));
                    if (!gfshInstance.isHeadlessMode()) {
                        gfshInstance.setPromptPath("");
                    }
                } else {
                    infoResultData.addLine("Not connected!");
                }
                result = ResultBuilder.buildResult(infoResultData);
            }
            catch (Exception e) {
                result = ResultBuilder.createConnectionErrorResult(CliStrings.format("Error occurred while disconnecting: {0}", (Object)e.getMessage()));
            }
        }
        return result;
    }
}

