/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class EchoCommand
implements GfshCommand {
    @CliCommand(value={"echo"}, help="Echo the given text which may include system and user variables.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result echo(@CliOption(key={"string", ""}, specifiedDefaultValue="", mandatory=true, help="String to be echoed. For example, \"SYS_USER variable is set to ${SYS_USER}\".") String stringToEcho) {
        Result result;
        if (stringToEcho.equals("$*")) {
            Gfsh gfshInstance = this.getGfsh();
            Map<String, String> envMap = gfshInstance.getEnv();
            Set<Map.Entry<String, String>> setEnvMap = envMap.entrySet();
            TabularResultData resultData = this.buildResultForEcho(setEnvMap);
            result = ResultBuilder.buildResult(resultData);
        } else {
            result = ResultBuilder.createInfoResult(stringToEcho);
        }
        return result;
    }

    private TabularResultData buildResultForEcho(Set<Map.Entry<String, String>> propertyMap) {
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        for (Map.Entry<String, String> setEntry : propertyMap) {
            resultData.accumulate("Property", setEntry.getKey());
            resultData.accumulate("Value", String.valueOf(setEntry.getValue()));
        }
        return resultData;
    }
}

