/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExecuteScriptCommand
implements GfshCommand {
    @CliCommand(value={"run"}, help="Execute a set of GFSH commands. Commands that normally prompt for additional input will instead use default values.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result executeScript(@CliOption(key={"file"}, optionContext="geode.converter.file", mandatory=true, help="File containing the GFSH commands to execute.") File file, @CliOption(key={"quiet"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to show command output.") boolean quiet, @CliOption(key={"continue-on-error"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether command execution should continue if an error is received.") boolean continueOnError) {
        Result result;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        try {
            result = gfsh.executeScript(file, quiet, continueOnError);
        }
        catch (IllegalArgumentException e) {
            result = ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        return result;
    }
}

