/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.Optional;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DataCommandUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ExportDataFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportDataCommand
implements GfshCommand {
    private final ExportDataFunction exportDataFunction = new ExportDataFunction();

    @CliCommand(value={"export data"}, help="Export user data from a region to a file.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public Result exportData(@CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Region from which data will be exported.") String regionName, @CliOption(key={"file"}, help="File to which the exported data will be written. The file must have an extension of \".gfd\". Cannot be specified at the same time as \"dir\"") String filePath, @CliOption(key={"dir"}, help="Directory to which the exported data will be written. Required if parallel set to true. Cannot be specified at the same time as \"file\"") String dirPath, @CliOption(key={"member"}, optionContext="geode.converter.member.idOrName", mandatory=true, help="Name/Id of a member which hosts the region. The data will be exported to the specified file on the host where the member is running.") String memberNameOrId, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Export local data on each node to a directory on that machine. Available for partitioned regions only") boolean parallel) {
        Result result;
        this.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
        if (targetMember == null) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found", (Object)memberNameOrId));
        }
        Optional<Result> validationResult = this.validatePath(filePath, dirPath, parallel);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            String path = dirPath != null ? this.defaultFileName(dirPath, regionName) : filePath;
            String[] args = new String[]{regionName, path, Boolean.toString(parallel)};
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.exportDataFunction, (Object)args, targetMember);
            result = DataCommandUtil.getFunctionResult(rc, "export data");
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    private String defaultFileName(String dirPath, String regionName) {
        return new File(dirPath, regionName + ".gfd").getAbsolutePath();
    }

    private Optional<Result> validatePath(String filePath, String dirPath, boolean parallel) {
        if (filePath == null && dirPath == null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Must specify a location to save snapshot"));
        }
        if (filePath != null && dirPath != null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Options \"file\" and \"dir\" cannot be specified at the same time"));
        }
        if (parallel && dirPath == null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Must specify a directory to save snapshot files"));
        }
        if (dirPath == null && !filePath.endsWith(".gfd")) {
            return Optional.of(ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd")));
        }
        return Optional.empty();
    }
}

