/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.StackTracesPerMember;
import org.apache.geode.management.internal.cli.functions.GetStackTracesFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportStackTraceCommand
implements GfshCommand {
    private final GetStackTracesFunction getStackTracesFunction = new GetStackTracesFunction();

    @CliCommand(value={"export stack-traces"}, help="Export the stack trace for a member or members.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportStackTrace(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName", help="Export the stack trace for a member or members.") String[] memberNameOrId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.all.member.idOrName", help="group") String[] group, @CliOption(key={"file"}, help="Name of the file to which the stack traces will be written.") String fileName, @CliOption(key={"abort-if-file-exists"}, unspecifiedDefaultValue="false", help="Abort the command if already exists at locator directory") boolean failIfFilePresent) {
        CommandResult result;
        StringBuilder filePrefix = new StringBuilder("stacktrace");
        if (fileName == null) {
            fileName = filePrefix.append("_").append(System.currentTimeMillis()).toString();
        }
        File outFile = new File(fileName);
        try {
            if (outFile.exists() && failIfFilePresent) {
                return ResultBuilder.createShellClientErrorResult(CliStrings.format("Error occurred while exporting stack-traces, file {0} already present", (Object)outFile.getCanonicalPath()));
            }
            InternalCache cache = this.getCache();
            InternalDistributedSystem ads = cache.getInternalDistributedSystem();
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            HashMap<String, byte[]> dumps = new HashMap<String, byte[]>();
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.getStackTracesFunction, null, targetMembers);
            ArrayList resultList = (ArrayList)rc.getResult();
            for (Object resultObj : resultList) {
                if (!(resultObj instanceof StackTracesPerMember)) continue;
                StackTracesPerMember stackTracePerMember = (StackTracesPerMember)resultObj;
                dumps.put(stackTracePerMember.getMemberNameOrId(), stackTracePerMember.getStackTraces());
            }
            String filePath = this.writeStacksToFile(dumps, fileName);
            resultData.addLine(CliStrings.format("stack-trace(s) exported to file: {0}", (Object)filePath));
            resultData.addLine("On host : " + ads.getDistributedMember().getHost());
            result = ResultBuilder.buildResult(resultData);
        }
        catch (IOException ex) {
            result = ResultBuilder.createGemFireErrorResult("Error occurred while showing stack-traces" + ex.getMessage());
        }
        return result;
    }

    private String writeStacksToFile(Map<String, byte[]> dumps, String fileName) throws IOException {
        String filePath;
        File outputFile = new File(fileName);
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            PrintWriter ps = new PrintWriter(os);
            for (Map.Entry<String, byte[]> entry : dumps.entrySet()) {
                int count;
                ps.append("*** Stack-trace for member ").append(entry.getKey()).append(" ***");
                ps.flush();
                GZIPInputStream zipIn = new GZIPInputStream(new ByteArrayInputStream(entry.getValue()));
                BufferedInputStream bin = new BufferedInputStream(zipIn);
                byte[] buffer = new byte[10000];
                while ((count = bin.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, count);
                }
                ps.append('\n');
            }
            ps.flush();
            filePath = outputFile.getCanonicalPath();
        }
        return filePath;
    }
}

