/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Optional;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DataCommandUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ImportDataFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ImportDataCommand
implements GfshCommand {
    private final ImportDataFunction importDataFunction = new ImportDataFunction();

    @CliCommand(value={"import data"}, help="Import user data from a file to a region.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public Result importData(@CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Region into which data will be imported.") String regionName, @CliOption(key={"file"}, help="File from which the imported data will be read. The file must have an extension of \".gfd\". Cannot be specified at the same time as \"dir\"") String filePath, @CliOption(key={"dir"}, help="Directory from which all data files (\".gfd\") will be read. Required if parallel set to true. Cannot be specified at the same time as \"file\"") String dirPath, @CliOption(key={"member"}, mandatory=true, optionContext="geode.converter.member.idOrName", help="Name/Id of a member which hosts the region. The data will be imported from the specified file on the host where the member is running.") String memberNameOrId, @CliOption(key={"invoke-callbacks"}, unspecifiedDefaultValue="false", help="Whether callbacks should be invoked") boolean invokeCallbacks, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Import data from given directory on all members. Used to import data from a parallel export. Available for partitioned regions only") boolean parallel) {
        Result result;
        this.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
        if (targetMember == null) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found.", (Object)memberNameOrId));
        }
        Optional<Result> validationResult = this.validatePath(filePath, dirPath, parallel);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            String path = dirPath != null ? dirPath : filePath;
            Object[] args = new Object[]{regionName, path, invokeCallbacks, parallel};
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.importDataFunction, (Object)args, targetMember);
            result = DataCommandUtil.getFunctionResult(rc, "import data");
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    private Optional<Result> validatePath(String filePath, String dirPath, boolean parallel) {
        if (filePath == null && dirPath == null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Must specify a location to load snapshot from"));
        }
        if (filePath != null && dirPath != null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Options \"file\" and \"dir\" cannot be specified at the same time"));
        }
        if (parallel && dirPath == null) {
            return Optional.of(ResultBuilder.createUserErrorResult("Must specify a directory to load snapshot files from"));
        }
        if (dirPath == null && !filePath.endsWith(".gfd")) {
            return Optional.of(ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd")));
        }
        return Optional.empty();
    }
}

