/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ListClientCommand
implements GfshCommand {
    @CliCommand(value={"list clients"}, help="Display list of connected clients")
    @CliMetaData(relatedTopic={"Client"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listClient() {
        CommandResult result;
        try {
            CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = compositeResultData.addSection("section1");
            TabularResultData resultTable = section.addTable("TableForClientList");
            String headerText = "ClientList";
            resultTable = resultTable.setHeader(headerText);
            InternalCache cache = this.getCache();
            ManagementService service = ManagementService.getExistingManagementService(cache);
            ObjectName[] cacheServers = service.getDistributedSystemMXBean().listCacheServerObjectNames();
            if (cacheServers.length == 0) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No cache-servers were observed.", new Object[0]));
            }
            HashMap clientServerMap = new HashMap();
            for (ObjectName objName : cacheServers) {
                CacheServerMXBean serverMbean = service.getMBeanInstance(objName, CacheServerMXBean.class);
                String[] listOfClient = serverMbean.getClientIds();
                if (listOfClient == null || listOfClient.length == 0) continue;
                for (String clientName : listOfClient) {
                    String serverDetails = "member=" + objName.getKeyProperty("member") + ",port=" + objName.getKeyProperty("port");
                    if (clientServerMap.containsKey(clientName)) {
                        List listServers = (List)clientServerMap.get(clientName);
                        listServers.add(serverDetails);
                        continue;
                    }
                    ArrayList<String> listServer = new ArrayList<String>();
                    listServer.add(serverDetails);
                    clientServerMap.put(clientName, listServer);
                }
            }
            if (clientServerMap.size() == 0) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No clients were retrieved for cache-servers.", new Object[0]));
            }
            String memberSeparator = ";  ";
            for (Map.Entry pairs : clientServerMap.entrySet()) {
                String client = (String)pairs.getKey();
                List servers = (List)pairs.getValue();
                StringBuilder serverListForClient = new StringBuilder();
                int serversSize = servers.size();
                int i = 0;
                for (String server : servers) {
                    serverListForClient.append(server);
                    if (i < serversSize - 1) {
                        serverListForClient.append(memberSeparator);
                    }
                    ++i;
                }
                resultTable.accumulate("Client Name / ID", client);
                resultTable.accumulate("Server Name / ID", serverListForClient.toString());
            }
            result = ResultBuilder.buildResult(compositeResultData);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error in list clients. stack trace" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve list of clients. Reason : {0}", (Object)e.getMessage()));
        }
        LogWrapper.getInstance().info("list client result " + result);
        return result;
    }
}

