/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.NetstatFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class NetstatCommand
implements GfshCommand {
    private static final String NETSTAT_FILE_REQUIRED_EXTENSION = ".txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"netstat"}, help="Report network information and statistics via the \"netstat\" operating system command.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result netstat(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName", help="Name/Id of the member(s) on which to run the netstat command.") String[] members, @CliOption(key={"group"}, optionContext="geode.converter.member.groups", help="Group of members on which to run the netstat command.") String group, @CliOption(key={"file"}, help="Text file to which output from the netstat command will be written. A \".txt\" extension will be added if it's not already a part of the specified name.") String saveAs, @CliOption(key={"with-lsof"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether lsof (list open files) command output should also be displayed. Not applicable for \"Microsoft Windows(TM)\" hosts.") boolean withlsof) {
        CommandResult result;
        HashMap<String, DistributedMember> hostMemberMap = new HashMap<String, DistributedMember>();
        HashMap<String, List<String>> hostMemberListMap = new HashMap<String, List<String>>();
        try {
            String lineSeparatorToUse;
            if (members != null && members.length > 0 && group != null) {
                throw new IllegalArgumentException("Only one of --group or --member should be specified.");
            }
            StringBuilder resultInfo = new StringBuilder();
            InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
            if (members != null) {
                HashSet<Object> notFoundMembers = new HashSet<Object>();
                for (String memberIdOrName : members) {
                    Set<DistributedMember> membersToExecuteOn = CliUtil.getAllMembers(system);
                    boolean memberFound = false;
                    for (DistributedMember distributedMember : membersToExecuteOn) {
                        String memberName = distributedMember.getName();
                        String memberId = distributedMember.getId();
                        if (!memberName.equals(memberIdOrName) && !memberId.equals(memberIdOrName)) continue;
                        this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                        memberFound = true;
                        break;
                    }
                    if (memberFound) continue;
                    notFoundMembers.add(memberIdOrName);
                }
                if (!notFoundMembers.isEmpty()) {
                    throw new IllegalArgumentException(CliStrings.format("Could not find member(s) with Id(s) or name(s): {0}.", new Object[]{CliUtil.collectionToString(notFoundMembers, -1)}));
                }
            } else {
                Set<DistributedMember> membersToExecuteOn = group != null ? system.getGroupMembers(group) : CliUtil.getAllMembers(system);
                for (DistributedMember distributedMember : membersToExecuteOn) {
                    String memberName = distributedMember.getName();
                    String memberId = distributedMember.getId();
                    String memberIdOrName = memberName != null && !memberName.isEmpty() ? memberName : memberId;
                    this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                }
            }
            if ((lineSeparatorToUse = CommandExecutionContext.getShellLineSeparator()) == null) {
                lineSeparatorToUse = GfshParser.LINE_SEPARATOR;
            }
            NetstatFunction.NetstatFunctionArgument nfa = new NetstatFunction.NetstatFunctionArgument(lineSeparatorToUse, withlsof);
            if (!hostMemberMap.isEmpty()) {
                HashSet<DistributedMember> membersToExecuteOn = new HashSet<DistributedMember>(hostMemberMap.values());
                ResultCollector<?, ?> netstatResult = CliUtil.executeFunction((Function)NetstatFunction.INSTANCE, (Object)nfa, membersToExecuteOn);
                List resultList = (List)netstatResult.getResult();
                for (Object aResultList : resultList) {
                    NetstatFunction.NetstatFunctionResult netstatFunctionResult = (NetstatFunction.NetstatFunctionResult)aResultList;
                    CliUtil.DeflaterInflaterData deflaterInflaterData = netstatFunctionResult.getCompressedBytes();
                    try {
                        String remoteHost = netstatFunctionResult.getHost();
                        List membersList = (List)hostMemberListMap.get(remoteHost);
                        resultInfo.append(MessageFormat.format(netstatFunctionResult.getHeaderInfo(), CliUtil.collectionToString(membersList, 120)));
                        CliUtil.DeflaterInflaterData uncompressedBytes = CliUtil.uncompressBytes(deflaterInflaterData.getData(), deflaterInflaterData.getDataLength());
                        resultInfo.append(new String(uncompressedBytes.getData()));
                    }
                    catch (DataFormatException e) {
                        resultInfo.append("Error in some data. Reason : ").append(e.getMessage());
                    }
                }
            }
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            if (saveAs != null && !saveAs.isEmpty()) {
                String saveToFile = saveAs;
                if (!saveAs.endsWith(NETSTAT_FILE_REQUIRED_EXTENSION)) {
                    saveToFile = saveAs + NETSTAT_FILE_REQUIRED_EXTENSION;
                }
                resultData.addAsFile(saveToFile, resultInfo.toString(), "Saved netstat output in the file {0}.", false);
            } else {
                resultData.addLine(resultInfo.toString());
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (IllegalArgumentException e) {
            LogWrapper.getInstance().info(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}));
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance().info(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}), e);
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing netstat on {0}", new Object[]{Arrays.toString(members)}));
        }
        finally {
            hostMemberMap.clear();
            hostMemberListMap.clear();
        }
        return result;
    }

    private void buildMaps(Map<String, DistributedMember> hostMemberMap, Map<String, List<String>> hostMemberListMap, String memberIdOrName, DistributedMember distributedMember) {
        List<Object> list;
        String host = distributedMember.getHost();
        if (!hostMemberMap.containsKey(host)) {
            hostMemberMap.put(host, distributedMember);
        }
        if (!hostMemberListMap.containsKey(host)) {
            list = new ArrayList();
            hostMemberListMap.put(host, list);
        } else {
            list = hostMemberListMap.get(host);
        }
        list.add(memberIdOrName);
    }
}

