/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GatewayCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class PauseGatewaySenderCommand
implements GfshCommand {
    @CliCommand(value={"pause gateway-sender"}, help="Pause the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result pauseGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which to pause the Gateway Sender.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member on which to pause the Gateway Sender.") String[] onMember) {
        CommandResult result;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        try {
            InternalCache cache = this.getCache();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findMembers(onGroup, onMember);
            if (dsMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            for (DistributedMember member : dsMembers) {
                GatewaySenderMXBean bean;
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        if (bean.isPaused()) {
                            GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is already paused on member {1}", senderId, member.getId()));
                            continue;
                        }
                        bean.pause();
                        GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is paused on member {1}", senderId, member.getId()));
                        continue;
                    }
                    GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not running on member {1}.", senderId, member.getId()));
                    continue;
                }
                GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }
}

