/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RemoveCommand
implements GfshCommand {
    public static final String REGION_NOT_FOUND = "Region <%s> not found in any of the members";

    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"remove"}, help="Remove an entry from a region. If using a region whose key class has been set, then specifying --key-class is unnecessary.")
    public Result remove(@CliOption(key={"key"}, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".", specifiedDefaultValue="") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to remove the entry.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"all"}, help="Clears the region by removing all entries. Partitioned region does not support remove-all", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean removeAllKeys, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass) {
        DataCommandResult dataResult;
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionPath)) {
            return ResultBuilder.createUserErrorResult("Region name is either empty or Null");
        }
        if (!removeAllKeys && key == null) {
            return ResultBuilder.createUserErrorResult("Key is Null");
        }
        if (removeAllKeys) {
            cache.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath);
        } else {
            cache.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath, key);
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction removefn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommandsUtils.getRegionAssociatedMembers(regionPath, this.getCache(), false);
            if (CollectionUtils.isEmpty(memberList)) {
                return ResultBuilder.createUserErrorResult(String.format(REGION_NOT_FOUND, regionPath));
            }
            DataCommandRequest request = new DataCommandRequest();
            request.setCommand("remove");
            request.setKey(key);
            request.setKeyClass(keyClass);
            request.setRemoveAllKeys(removeAllKeys ? "ALL" : null);
            request.setRegionName(regionPath);
            dataResult = DataCommandsUtils.callFunctionForRegion(request, removefn, memberList);
        } else {
            dataResult = removefn.remove(key, keyClass, regionPath, removeAllKeys ? "ALL" : null);
        }
        dataResult.setKeyClass(keyClass);
        return DataCommandsUtils.makePresentationResult(dataResult);
    }
}

