/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShowLogCommand
implements GfshCommand {
    @CliCommand(value={"show log"}, help="Display the log for a member.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showLog(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", help="Name/Id of the member whose log file will be displayed.", mandatory=true) String memberNameOrId, @CliOption(key={"lines"}, unspecifiedDefaultValue="0", help="Number of lines from the log file to display. The maximum is 100.") int numberOfLines) {
        CommandResult result;
        try {
            InternalCache cache = this.getCache();
            DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            if (targetMember == null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(memberNameOrId + " " + "Member not found");
                return ResultBuilder.buildResult(errorResultData);
            }
            MemberMXBean targetMemberMXBean = this.getMemberMxBean(cache, targetMember);
            if (numberOfLines > 100) {
                numberOfLines = 100;
            }
            if (numberOfLines == 0 || numberOfLines < 0) {
                numberOfLines = 30;
            }
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            if (targetMemberMXBean != null) {
                String log = targetMemberMXBean.showLog(numberOfLines);
                if (log != null) {
                    resultData.addLine(log);
                } else {
                    resultData.addLine("There is no log for this member");
                }
            } else {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(memberNameOrId + "Member not found");
                return ResultBuilder.buildResult(errorResultData);
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Error" + CliUtil.stackTraceAsString(e));
        }
        return result;
    }

    public MemberMXBean getMemberMxBean(InternalCache cache, DistributedMember targetMember) {
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
        if (cache.getDistributedSystem().getDistributedMember().equals(targetMember)) {
            return service.getMemberMXBean();
        }
        ObjectName objectName = service.getMemberMBeanName(targetMember);
        return service.getMBeanProxy(objectName, MemberMXBean.class);
    }
}

