/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.JVMMetrics;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShowMetricsCommand
implements GfshCommand {
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"show metrics"}, help="Display or export metrics for the entire distributed system, a member or a region.")
    @CliMetaData(relatedTopic={"Statistics"}, interceptor="org.apache.geode.management.internal.cli.commands.ShowMetricsCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showMetrics(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName", help="Name/Id of the member whose metrics will be displayed/exported.") String memberNameOrId, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose metrics will be displayed/exported.") String regionName, @CliOption(key={"file"}, help="Name of the file to which metrics will be written.") String export_to_report_to, @CliOption(key={"port"}, help="Port number of the Cache Server whose metrics are to be displayed/exported. This can only be used along with the --member parameter.") String cacheServerPortString, @CliOption(key={"categories"}, help="Categories available based upon the parameters specified are:\n- no parameters specified: cluster, cache, diskstore, query\n- region specified: cluster, region, partition, diskstore, callback, eviction\n- member specified: member, jvm, region, serialization, communication, function, transaction, diskstore, lock, eviction, distribution, offheap\n- member and region specified: region, partition, diskstore, callback, eviction") String[] categories) {
        CommandResult result;
        DistributedMember member = null;
        if (memberNameOrId != null && (member = CliUtil.getDistributedMemberByNameOrId(memberNameOrId)) == null) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberNameOrId));
        }
        if (regionName != null) {
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            result = memberNameOrId != null ? ResultBuilder.buildResult(this.getRegionMetricsFromMember(regionName, member, export_to_report_to, categories)) : ResultBuilder.buildResult(this.getDistributedRegionMetrics(regionName, export_to_report_to, categories));
        } else if (memberNameOrId != null) {
            int cacheServerPort = -1;
            if (cacheServerPortString != null) {
                cacheServerPort = Integer.parseInt(cacheServerPortString);
            }
            result = ResultBuilder.buildResult(this.getMemberMetrics(member, export_to_report_to, categories, cacheServerPort));
        } else {
            result = ResultBuilder.buildResult(this.getSystemWideMetrics(export_to_report_to, categories));
        }
        return result;
    }

    private ResultData getSystemWideMetrics(String export_to_report_to, String[] categoriesArr) {
        InternalCache cache = this.getCache();
        ManagementService managementService = ManagementService.getManagementService(cache);
        DistributedSystemMXBean dsMxBean = managementService.getDistributedSystemMXBean();
        StringBuilder csvBuilder = null;
        if (dsMxBean != null) {
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            Map<String, Boolean> categoriesMap = this.getSystemMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            metricsTable.setHeader("Cluster-wide Metrics");
            if (categoriesMap.get("cluster").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cluster", "totalHeapSize", dsMxBean.getTotalHeapSize(), csvBuilder);
            }
            if (categoriesMap.get("cache").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cache", "totalRegionEntryCount", dsMxBean.getTotalRegionEntryCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalRegionCount", dsMxBean.getTotalRegionCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalMissCount", dsMxBean.getTotalMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalHitCount", dsMxBean.getTotalHitCount(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", dsMxBean.getTotalDiskUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", dsMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", dsMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", dsMxBean.getDiskFlushAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", dsMxBean.getTotalBackupInProgress(), csvBuilder);
            }
            if (categoriesMap.get("query").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", dsMxBean.getActiveCQCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "queryRequestRate", dsMxBean.getQueryRequestRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder.toString(), "Cluster wide metrics exported to {0}.", false);
            }
            return crd;
        }
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)"Distributed System MBean not found");
        return ResultBuilder.createErrorResultData().addLine(errorMessage);
    }

    private ResultData getMemberMetrics(DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr, int cacheServerPort) throws ResultDataException {
        InternalCache cache = this.getCache();
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        ObjectName memberMBeanName = managementService.getMemberMBeanName(distributedMember);
        MemberMXBean memberMxBean = managementService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
        CacheServerMXBean csMxBean = null;
        if (memberMxBean != null) {
            ObjectName csMxBeanName;
            if (cacheServerPort != -1 && (csMxBean = managementService.getMBeanInstance(csMxBeanName = managementService.getCacheServerMBeanName(cacheServerPort, distributedMember), CacheServerMXBean.class)) == null) {
                ErrorResultData erd = ResultBuilder.createErrorResultData();
                erd.addLine(CliStrings.format("Metrics for the Cache Server with port : {0} and member : {1} not found.\n Please check the port number and the member name/id", cacheServerPort, MBeanJMXAdapter.getMemberNameOrId(distributedMember)));
                return erd;
            }
            JVMMetrics jvmMetrics = memberMxBean.showJVMMetrics();
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Member Metrics");
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getMemberMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("member").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "member", "upTime", memberMxBean.getMemberUpTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cpuUsage", memberMxBean.getCpuUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "currentHeapSize", memberMxBean.getCurrentHeapSize(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "maximumHeapSize", memberMxBean.getMaximumHeapSize(), csvBuilder);
            }
            if (categoriesMap.get("jvm").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "jvm ", "jvmThreads ", jvmMetrics.getTotalThreads(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "fileDescriptorLimit", memberMxBean.getFileDescriptorLimit(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalFileDescriptorOpen", memberMxBean.getTotalFileDescriptorOpen(), csvBuilder);
            }
            if (categoriesMap.get("region").booleanValue()) {
                String[] rootRegionNames;
                this.writeToTableAndCsv(metricsTable, "region ", "totalRegionCount ", memberMxBean.getTotalRegionCount(), csvBuilder);
                String[] regionNames = memberMxBean.listRegions();
                if (regionNames != null) {
                    for (int i = 0; i < regionNames.length; ++i) {
                        if (i == 0) {
                            this.writeToTableAndCsv(metricsTable, "listOfRegions", regionNames[i].substring(1), csvBuilder);
                            continue;
                        }
                        this.writeToTableAndCsv(metricsTable, "", regionNames[i].substring(1), csvBuilder);
                    }
                }
                if ((rootRegionNames = memberMxBean.getRootRegionNames()) != null) {
                    for (int i = 0; i < rootRegionNames.length; ++i) {
                        if (i == 0) {
                            this.writeToTableAndCsv(metricsTable, "rootRegions", rootRegionNames[i], csvBuilder);
                            continue;
                        }
                        this.writeToTableAndCsv(metricsTable, "", rootRegionNames[i], csvBuilder);
                    }
                }
                this.writeToTableAndCsv(metricsTable, "", "totalRegionEntryCount", memberMxBean.getTotalRegionEntryCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketCount", memberMxBean.getTotalBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalPrimaryBucketCount", memberMxBean.getTotalPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsAvgLatency", memberMxBean.getGetsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsAvgLatency", memberMxBean.getPutsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", memberMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", memberMxBean.getDestroysRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllAvgLatency", memberMxBean.getPutAllAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalMissCount", memberMxBean.getTotalMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalHitCount", memberMxBean.getTotalHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", memberMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", memberMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheWriterCallsAvgLatency", memberMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", memberMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalLoadsCompleted", memberMxBean.getTotalLoadsCompleted(), csvBuilder);
            }
            if (categoriesMap.get("serialization").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "serialization", "serializationRate", memberMxBean.getSerializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "serializationLatency", memberMxBean.getSerializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationRate", memberMxBean.getDeserializationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationLatency", memberMxBean.getDeserializationLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "deserializationAvgLatency", memberMxBean.getDeserializationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationAvgLatency", memberMxBean.getPDXDeserializationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationRate", memberMxBean.getPDXDeserializationRate(), csvBuilder);
            }
            if (categoriesMap.get("communication").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "communication", "bytesSentRate", memberMxBean.getBytesSentRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bytesReceivedRate", memberMxBean.getBytesReceivedRate(), csvBuilder);
                String[] connectedGatewayReceivers = memberMxBean.listConnectedGatewayReceivers();
                this.writeToTableAndCsv(metricsTable, "connectedGatewayReceivers", connectedGatewayReceivers, csvBuilder);
                String[] connectedGatewaySenders = memberMxBean.listConnectedGatewaySenders();
                this.writeToTableAndCsv(metricsTable, "connectedGatewaySenders", connectedGatewaySenders, csvBuilder);
            }
            if (categoriesMap.get("function").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "function", "numRunningFunctions", memberMxBean.getNumRunningFunctions(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "functionExecutionRate", memberMxBean.getFunctionExecutionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numRunningFunctionsHavingResults", memberMxBean.getNumRunningFunctionsHavingResults(), csvBuilder);
            }
            if (categoriesMap.get("transaction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "transaction", "totalTransactionsCount", memberMxBean.getTotalTransactionsCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommitsAvgLatency", memberMxBean.getTransactionCommitsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommittedTotalCount", memberMxBean.getTransactionCommittedTotalCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionRolledBackTotalCount", memberMxBean.getTransactionRolledBackTotalCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "transactionCommitsRate", memberMxBean.getTransactionCommitsRate(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", memberMxBean.getTotalDiskUsage(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", memberMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", memberMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", memberMxBean.getDiskFlushAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalQueueSize", memberMxBean.getTotalDiskTasksWaiting(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", memberMxBean.getTotalBackupInProgress(), csvBuilder);
            }
            if (categoriesMap.get("lock").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "lock", "lockWaitsInProgress", memberMxBean.getLockWaitsInProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalLockWaitTime", memberMxBean.getTotalLockWaitTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalNumberOfLockService", memberMxBean.getTotalNumberOfLockService(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "requestQueues", memberMxBean.getLockRequestQueues(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", memberMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", memberMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (categoriesMap.get("distribution").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "distribution", "getInitialImagesInProgress", memberMxBean.getInitialImagesInProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getInitialImageTime", memberMxBean.getInitialImageTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getInitialImageKeysReceived", memberMxBean.getInitialImageKeysReceived(), csvBuilder);
            }
            if (categoriesMap.get("offheap").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "offheap", "maxMemory", memberMxBean.getOffHeapMaxMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "freeMemory", memberMxBean.getOffHeapFreeMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "usedMemory", memberMxBean.getOffHeapUsedMemory(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "objects", memberMxBean.getOffHeapObjects(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "fragmentation", memberMxBean.getOffHeapFragmentation(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "compactionTime", memberMxBean.getOffHeapCompactionTime(), csvBuilder);
            }
            if (csMxBean != null) {
                this.writeToTableAndCsv(metricsTable, "cache-server", "clientConnectionCount", csMxBean.getClientConnectionCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "hostnameForClients", csMxBean.getHostNameForClients(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getRequestAvgLatency", csMxBean.getGetRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRequestAvgLatency", csMxBean.getPutRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalConnectionsTimedOut", csMxBean.getTotalConnectionsTimedOut(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "threadQueueSize", csMxBean.getPutRequestAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "connectionThreads", csMxBean.getConnectionThreads(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "connectionLoad", csMxBean.getConnectionLoad(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "loadPerConnection", csMxBean.getLoadPerConnection(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "queueLoad", csMxBean.getQueueLoad(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "loadPerQueue", csMxBean.getLoadPerQueue(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getRequestRate", csMxBean.getGetRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRequestRate", csMxBean.getPutRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "notification", "numClientNotificationRequests", csMxBean.getNumClientNotificationRequests(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "clientNotificationRate", csMxBean.getClientNotificationRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "clientNotificationAvgLatency", csMxBean.getClientNotificationAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", csMxBean.getActiveCQCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "query", "queryRequestRate", csMxBean.getQueryRequestRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "indexCount", csMxBean.getIndexCount(), csvBuilder);
                String[] indexList = csMxBean.getIndexList();
                this.writeToTableAndCsv(metricsTable, "index list", indexList, csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalIndexMaintenanceTime", csMxBean.getTotalIndexMaintenanceTime(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null, "Member metrics exported to {0}.", false);
            }
            return crd;
        }
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Member MBean for " + MBeanJMXAdapter.getMemberNameOrId(distributedMember) + " not found"));
        return ResultBuilder.createErrorResultData().addLine(errorMessage);
    }

    private ResultData getDistributedRegionMetrics(String regionName, String export_to_report_to, String[] categoriesArr) throws ResultDataException {
        InternalCache cache = this.getCache();
        ManagementService managementService = ManagementService.getManagementService(cache);
        DistributedRegionMXBean regionMxBean = managementService.getDistributedRegionMXBean(regionName);
        if (regionMxBean != null) {
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Cluster-wide Region Metrics");
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getSystemRegionMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("cluster").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "cluster", "member count", regionMxBean.getMemberCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "region entry count", regionMxBean.getSystemRegionEntryCount(), csvBuilder);
            }
            if (categoriesMap.get("region").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
            }
            if (categoriesMap.get("partition").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "averageBucketSize", regionMxBean.getAvgBucketSize(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", regionMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
            }
            if (categoriesMap.get("callback").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null, "Aggregate Region Metrics exported to {0}.", false);
            }
            return crd;
        }
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Distributed Region MBean for " + regionName + " not found"));
        erd.addLine(errorMessage);
        return erd;
    }

    private ResultData getRegionMetricsFromMember(String regionName, DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr) throws ResultDataException {
        ObjectName regionMBeanName;
        InternalCache cache = this.getCache();
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        RegionMXBean regionMxBean = managementService.getMBeanInstance(regionMBeanName = managementService.getRegionMBeanName(distributedMember, regionName), RegionMXBean.class);
        if (regionMxBean != null) {
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = crd.addSection();
            TabularResultData metricsTable = section.addTable();
            metricsTable.setHeader("Metrics for region:" + regionName + " On Member " + MBeanJMXAdapter.getMemberNameOrId(distributedMember));
            StringBuilder csvBuilder = null;
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                csvBuilder = new StringBuilder();
                csvBuilder.append("Category");
                csvBuilder.append(',');
                csvBuilder.append("Metric");
                csvBuilder.append(',');
                csvBuilder.append("Value");
                csvBuilder.append('\n');
            }
            Map<String, Boolean> categoriesMap = this.getRegionMetricsCategories();
            if (categoriesArr != null && categoriesArr.length != 0) {
                HashSet<String> checkSet;
                Set<String> categories = this.createSet(categoriesArr);
                Set<String> userCategories = this.getSetDifference(categories, checkSet = new HashSet<String>(categoriesMap.keySet()));
                if (userCategories.isEmpty()) {
                    for (String category : checkSet) {
                        categoriesMap.put(category, false);
                    }
                    for (String category : categories) {
                        categoriesMap.put(category.toLowerCase(), true);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid Categories\n");
                    for (String category : userCategories) {
                        sb.append(category);
                        sb.append('\n');
                    }
                    return ResultBuilder.createErrorResultData().addLine(sb.toString());
                }
            }
            if (categoriesMap.get("region").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
            }
            if (categoriesMap.get("partition").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "configuredRedundancy", regionMxBean.getConfiguredRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "actualRedundancy", regionMxBean.getActualRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
            }
            if (categoriesMap.get("diskstore").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "diskReadsRate", "" + regionMxBean.getDiskReadsRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
            }
            if (categoriesMap.get("callback").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
            }
            if (categoriesMap.get("eviction").booleanValue()) {
                this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
                this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
            }
            if (export_to_report_to != null && !export_to_report_to.isEmpty()) {
                crd.addAsFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null, "Region Metrics exported to {0}.", false);
            }
            return crd;
        }
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Region MBean for " + regionName + " on member " + MBeanJMXAdapter.getMemberNameOrId(distributedMember) + " not found"));
        erd.addLine(errorMessage);
        return erd;
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, long metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String type, String metricName, double metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private Set<String> createSet(String[] categories) {
        HashSet<String> categoriesSet = new HashSet<String>();
        Collections.addAll(categoriesSet, categories);
        return categoriesSet;
    }

    private Set<String> getSetDifference(Set<String> set1, Set<String> set2) {
        HashSet<String> setDifference = new HashSet<String>();
        for (String element : set1) {
            if (set2.contains(element.toLowerCase())) continue;
            setDifference.add(element);
        }
        return setDifference;
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String metricName, String[] metricValue, StringBuilder csvBuilder) {
        if (metricValue != null) {
            for (int i = 0; i < metricValue.length; ++i) {
                if (i == 0) {
                    this.writeToTableAndCsv(metricsTable, metricName, metricValue[i], csvBuilder);
                    continue;
                }
                this.writeToTableAndCsv(metricsTable, "", metricValue[i], csvBuilder);
            }
        }
    }

    private void writeToTableAndCsv(TabularResultData metricsTable, String metricName, String metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", "");
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        if (csvBuilder != null) {
            csvBuilder.append("");
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private Map<String, Boolean> getRegionMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("region", true);
        categories.put("partition", true);
        categories.put("diskstore", true);
        categories.put("callback", true);
        categories.put("gatewayreceiver", true);
        categories.put("distribution", true);
        categories.put("query", true);
        categories.put("eviction", true);
        return categories;
    }

    private Map<String, Boolean> getSystemMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("cluster", true);
        categories.put("cache", true);
        categories.put("diskstore", true);
        categories.put("query", true);
        return categories;
    }

    private Map<String, Boolean> getSystemRegionMetricsCategories() {
        Map<String, Boolean> categories = this.getRegionMetricsCategories();
        categories.put("cluster", true);
        return categories;
    }

    private Map<String, Boolean> getMemberMetricsCategories() {
        HashMap<String, Boolean> categories = new HashMap<String, Boolean>();
        categories.put("member", true);
        categories.put("jvm", true);
        categories.put("region", true);
        categories.put("serialization", true);
        categories.put("communication", true);
        categories.put("function", true);
        categories.put("transaction", true);
        categories.put("diskstore", true);
        categories.put("lock", true);
        categories.put("eviction", true);
        categories.put("distribution", true);
        categories.put("offheap", true);
        return categories;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String export_to_report_to = parseResult.getParamValue("file");
            if (export_to_report_to != null && !export_to_report_to.endsWith(".csv")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".csv"));
            }
            String regionName = parseResult.getParamValue("region");
            String port = parseResult.getParamValue("port");
            if (port != null) {
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    return ResultBuilder.createUserErrorResult("Invalid port");
                }
            }
            if (regionName != null && port != null) {
                return ResultBuilder.createUserErrorResult("The --region and --port parameters are mutually exclusive. Please only use one or the other.");
            }
            String member = parseResult.getParamValue("member");
            if (port != null && member == null) {
                return ResultBuilder.createUserErrorResult("If the --port parameter is specified, then the --member parameter must also be specified.");
            }
            return ResultBuilder.createInfoResult("OK");
        }
    }
}

