/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GatewayCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartGatewayReceiverCommand
implements GfshCommand {
    @CliCommand(value={"start gateway-receiver"}, help="Start the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result startGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of members on which to start the Gateway Receiver.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the member on which to start the Gateway Receiver.") String[] onMember) {
        Result result;
        try {
            InternalCache cache = this.getCache();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            Set<DistributedMember> dsMembers = CliUtil.findMembers(onGroup, onMember);
            if (dsMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            for (DistributedMember member : dsMembers) {
                ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
                if (gatewayReceiverObjectName != null) {
                    GatewayReceiverMXBean receiverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                    if (receiverBean != null) {
                        if (receiverBean.isRunning()) {
                            GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is already started on member {0}", new Object[]{member.getId()}));
                            continue;
                        }
                        receiverBean.start();
                        GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewayReceiver is started on member {0}", new Object[]{member.getId()}));
                        continue;
                    }
                    GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
                    continue;
                }
                GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewayReceiver is not available on member {0}", new Object[]{member.getId()}));
            }
            result = ResultBuilder.buildResult(resultData);
        }
        catch (CommandResultException crex) {
            result = GatewayCommandsUtils.handleCommandResultException(crex);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }
}

