/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusGatewayReceiverCommand
implements GfshCommand {
    @CliCommand(value={"status gateway-receiver"}, help="Display the status of a Gateway Receiver.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result statusGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups", help="Group(s) of Gateway Receivers for which to display status.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName", help="Name/Id of the Gateway Receiver for which to display status.") String[] onMember) {
        CommandResult result;
        try {
            InternalCache cache = this.getCache();
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            TabularResultData availableReceiverData = crd.addSection("Available GatewayReceiver Section").addTable("GatewayReceiver Table");
            TabularResultData notAvailableReceiverData = crd.addSection("Not Available GatewayReceiver Section").addTable("GatewayReceiver Table");
            Set<DistributedMember> dsMembers = CliUtil.findMembers(onGroup, onMember);
            if (dsMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            for (DistributedMember member : dsMembers) {
                GatewayReceiverMXBean receiverBean;
                ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
                if (gatewayReceiverObjectName != null && (receiverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) != null) {
                    this.buildReceiverStatus(member.getId(), receiverBean, availableReceiverData);
                    continue;
                }
                this.buildReceiverStatus(member.getId(), null, notAvailableReceiverData);
            }
            result = ResultBuilder.buildResult(crd);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult("Error" + e.getMessage());
        }
        return result;
    }

    private TabularResultData buildReceiverStatus(String memberId, GatewayReceiverMXBean bean, TabularResultData resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Port", bean.getPort());
            resultData.accumulate("Status", bean.isRunning() ? "Running" : "Not Running");
        } else {
            resultData.accumulate("Error", "GatewayReceiver is not available or already stopped");
        }
        return resultData;
    }
}

