/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.IOException;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.apache.geode.management.internal.cli.util.HostUtils;
import org.apache.geode.management.internal.configuration.utils.ClusterConfigurationStatusRetriever;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusLocatorCommand
implements GfshCommand {
    @CliCommand(value={"status locator"}, help="Display the status of a Locator. Possible statuses are: started, online, offline or not responding.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result statusLocator(@CliOption(key={"name"}, optionContext="geode.converter.locatormember.idOrName", help="Member name or ID of the Locator in the Geode cluster.") String member, @CliOption(key={"host"}, help="Hostname or IP address on which the Locator is running.") String locatorHost, @CliOption(key={"port"}, help="Port on which the Locator is listening. The default is 10334.") Integer locatorPort, @CliOption(key={"pid"}, help="Process ID (PID) of the running Locator. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, help="Working directory in which the Locator is running. The default is the current directory.") String workingDirectory) {
        try {
            if (StringUtils.isNotBlank((String)member)) {
                if (this.isConnectedAndReady()) {
                    MemberMXBean locatorProxy = MXBeanProvider.getMemberMXBean(member);
                    if (locatorProxy != null) {
                        LocatorLauncher.LocatorState state = LocatorLauncher.LocatorState.fromJson(locatorProxy.status());
                        return this.createStatusLocatorResult(state);
                    }
                    return ResultBuilder.createUserErrorResult(CliStrings.format("No Locator with member name or ID {0} could be found.", (Object)member));
                }
                return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Locator"));
            }
            LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STATUS).setBindAddress(locatorHost).setDebug(this.isDebugging()).setPid(pid).setPort(locatorPort).setWorkingDirectory(workingDirectory).build();
            LocatorLauncher.LocatorState status = locatorLauncher.status();
            if (status.getStatus().equals((Object)AbstractLauncher.Status.NOT_RESPONDING) || status.getStatus().equals((Object)AbstractLauncher.Status.STOPPED)) {
                return ResultBuilder.createShellClientErrorResult(status.toString());
            }
            return this.createStatusLocatorResult(status);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to determine the state of Locator on %1$s running in %2$s: %3$s", HostUtils.getLocatorId(locatorHost, locatorPort), StringUtils.defaultIfBlank((String)workingDirectory, (String)SystemUtils.CURRENT_DIRECTORY), this.toString(t, this.getGfsh().getDebug())));
        }
    }

    protected Result createStatusLocatorResult(LocatorLauncher.LocatorState state) throws NumberFormatException, IOException, ClassNotFoundException {
        InfoResultData infoResultData = ResultBuilder.createInfoResultData();
        infoResultData.addLine(state.toString());
        infoResultData.addLine(ClusterConfigurationStatusRetriever.fromLocator(state));
        return ResultBuilder.buildResult(infoResultData);
    }
}

