/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.util.StopWatch;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StopLocatorCommand
implements GfshCommand {
    private static final long WAITING_FOR_STOP_TO_MAKE_PID_GO_AWAY_TIMEOUT_MILLIS = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CliCommand(value={"stop locator"}, help="Stop a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result stopLocator(@CliOption(key={"name"}, optionContext="geode.converter.locatormember.idOrName", help="Member name or ID of the Locator in the Geode cluster.") String member, @CliOption(key={"pid"}, help="The process id (PID) of the running Locator. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, help="Working directory in which the Locator is running. The default is the current directory.") String workingDirectory) {
        Object stopWatch;
        LocatorLauncher.LocatorState locatorState;
        try {
            if (StringUtils.isNotBlank((String)member)) {
                if (!this.isConnectedAndReady()) {
                    CommandResult locatorProxy = ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to stop a {0} by member name or ID.", (Object)"Locator"));
                    return locatorProxy;
                }
                MemberMXBean locatorProxy = MXBeanProvider.getMemberMXBean(member);
                if (locatorProxy == null) {
                    CommandResult commandResult = ResultBuilder.createUserErrorResult(CliStrings.format("No Locator with member name or ID {0} could be found.", (Object)member));
                    return commandResult;
                }
                if (!locatorProxy.isLocator()) {
                    throw new IllegalStateException(CliStrings.format("The Geode member identified by {0} is not a Locator and cannot be shutdown using 'stop locator'.", (Object)member));
                }
                if (locatorProxy.isServer()) {
                    throw new IllegalStateException(CliStrings.format("The Locator identified by {0} is also a cache server and cannot be shutdown using 'stop locator'.  Please use 'stop server' instead.", (Object)member));
                }
                locatorState = LocatorLauncher.LocatorState.fromJson(locatorProxy.status());
                locatorProxy.shutDownMember();
            } else {
                LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STOP).setDebug(this.isDebugging()).setPid(pid).setWorkingDirectory(workingDirectory).build();
                locatorState = locatorLauncher.status();
                locatorLauncher.stop();
            }
            if (!AbstractLauncher.Status.ONLINE.equals((Object)locatorState.getStatus())) {
                stopWatch = ResultBuilder.createUserErrorResult(locatorState.toString());
                return stopWatch;
            }
            this.getGfsh().logInfo(String.format("Stopping Locator running in %1$s on %2$s as %3$s...%nProcess ID: %4$d%nLog File: %5$s", locatorState.getWorkingDirectory(), locatorState.getServiceLocation(), locatorState.getMemberName(), locatorState.getPid(), locatorState.getLogFile()), null);
            stopWatch = new StopWatch(true);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            CommandResult commandResult = ResultBuilder.createUserErrorResult(e.getMessage());
            return commandResult;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            CommandResult commandResult = ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to stop a Locator: %1$s", this.toString(t, this.getGfsh().getDebug())));
            return commandResult;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
        while (locatorState.isVmWithProcessIdRunning()) {
            Gfsh.print(".");
            if (((StopWatch)stopWatch).elapsedTimeMillis() > 30000L) break;
            StopLocatorCommand stopLocatorCommand = this;
            synchronized (stopLocatorCommand) {
                TimeUnit.MILLISECONDS.timedWait(this, 500L);
            }
        }
        return ResultBuilder.createInfoResult("");
    }
}

