/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.util.StopWatch;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StopServerCommand
implements GfshCommand {
    private static final long WAITING_FOR_STOP_TO_MAKE_PID_GO_AWAY_TIMEOUT_MILLIS = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"stop server"}, help="Stop a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result stopServer(@CliOption(key={"name"}, optionContext="geode.converter.member.idOrName", help="Member name or ID of the Cache Server in the Geode cluster.") String member, @CliOption(key={"pid"}, help="Process ID (PID) of the running Geode Cache Server. Deprecated: Since Geode1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, help="Working directory in which the Cache Server is running. The default is the current directory.") String workingDirectory) {
        try {
            Object stopWatch;
            ServerLauncher.ServerState serverState;
            if (StringUtils.isNotBlank((String)member)) {
                if (!this.isConnectedAndReady()) {
                    CommandResult commandResult = ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to stop a {0} by member name or ID.", (Object)"Cache Server"));
                    return commandResult;
                }
                MemberMXBean serverProxy = MXBeanProvider.getMemberMXBean(member);
                if (serverProxy != null) {
                    if (!serverProxy.isServer()) {
                        throw new IllegalStateException(CliStrings.format("Attempting to stop a Geode member that is not a Cache Server using 'stop server'; the operation is not permitted.", (Object)member));
                    }
                } else {
                    CommandResult commandResult = ResultBuilder.createUserErrorResult(CliStrings.format("No Cache Server with member name or ID {0} could be found.", (Object)member));
                    return commandResult;
                }
                serverState = ServerLauncher.ServerState.fromJson(serverProxy.status());
                serverProxy.shutDownMember();
            } else {
                ServerLauncher serverLauncher = new ServerLauncher.Builder().setCommand(ServerLauncher.Command.STOP).setDebug(this.isDebugging()).setPid(pid).setWorkingDirectory(workingDirectory).build();
                serverState = serverLauncher.status();
                serverLauncher.stop();
            }
            if (AbstractLauncher.Status.ONLINE.equals((Object)serverState.getStatus())) {
                Object object;
                this.getGfsh().logInfo(String.format("Stopping Cache Server running in %1$s on %2$s as %3$s...%nProcess ID: %4$d%nLog File: %5$s", serverState.getWorkingDirectory(), serverState.getServiceLocation(), serverState.getMemberName(), serverState.getPid(), serverState.getLogFile()), null);
                stopWatch = new StopWatch(true);
                while (serverState.isVmWithProcessIdRunning()) {
                    Gfsh.print(".");
                    if (((StopWatch)stopWatch).elapsedTimeMillis() > 30000L) break;
                    object = this;
                    synchronized (object) {
                        TimeUnit.MILLISECONDS.timedWait(this, 500L);
                    }
                }
                object = ResultBuilder.createInfoResult("");
                return object;
            }
            stopWatch = ResultBuilder.createUserErrorResult(serverState.toString());
            return stopWatch;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            CommandResult commandResult = ResultBuilder.createUserErrorResult(e.getMessage());
            return commandResult;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            CommandResult commandResult = ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to stop a Cache Server: %1$s", this.toString(t, this.getGfsh().getDebug())));
            return commandResult;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
    }

    private void stop(String member) {
    }

    private void stop(String pid, String workingDir) {
    }
}

