/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class ClusterMemberIdNameConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "geode.converter.all.member.idOrName".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "geode.converter.all.member.idOrName".equals(optionContext)) {
            Set<String> memberIdAndNames = this.getMemberIdAndNames();
            for (String string : memberIdAndNames) {
                completions.add(new Completion(string));
            }
        }
        return !completions.isEmpty();
    }

    private Set<String> getMemberIdAndNames() {
        String[] memberIds;
        TreeSet<String> memberIdsAndNames = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (memberIds = gfsh.getOperationInvoker().getDistributedSystemMXBean().listMembers()) != null && memberIds.length != 0) {
            memberIdsAndNames.addAll(Arrays.asList(memberIds));
        }
        return memberIdsAndNames;
    }
}

