/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class RegionPathConverter
implements Converter<String> {
    public static final String DEFAULT_APP_CONTEXT_PATH = "";

    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && optionContext.contains("geode.converter.region.path:disable-string-converter");
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        Set<String> regionPathSet = this.getAllRegionPaths();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        String currentContextPath = DEFAULT_APP_CONTEXT_PATH;
        if (gfsh != null && (currentContextPath = gfsh.getEnvProperty("APP_CONTEXT_PATH")) != null && !DEFAULT_APP_CONTEXT_PATH.equals(currentContextPath)) {
            regionPathSet.remove(currentContextPath);
            regionPathSet.add(DEFAULT_APP_CONTEXT_PATH);
        }
        for (String regionPath : regionPathSet) {
            if (existingData != null) {
                if (!regionPath.startsWith(existingData)) continue;
                completions.add(new Completion(regionPath));
                continue;
            }
            completions.add(new Completion(regionPath));
        }
        return !completions.isEmpty();
    }

    public Set<String> getAllRegionPaths() {
        String[] regionPaths;
        Set<String> regionPathSet = Collections.emptySet();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (regionPaths = gfsh.getOperationInvoker().getDistributedSystemMXBean().listAllRegionPaths()) != null && regionPaths.length > 0) {
            regionPathSet = new TreeSet<String>();
            for (String regionPath : regionPaths) {
                if (regionPath == null) continue;
                regionPathSet.add(regionPath);
            }
        }
        return regionPathSet;
    }
}

