/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class DeployFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = DeployFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            String[] jarFilenames = (String[])args[0];
            byte[][] jarBytes = (byte[][])args[1];
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            ArrayList<String> deployedList = new ArrayList<String>();
            List<DeployedJar> jarClassLoaders = ClassPathLoader.getLatest().getJarDeployer().deploy(jarFilenames, jarBytes);
            for (int i = 0; i < jarFilenames.length; ++i) {
                deployedList.add(jarFilenames[i]);
                if (jarClassLoaders.get(i) != null) {
                    deployedList.add(jarClassLoaders.get(i).getFileCanonicalPath());
                    continue;
                }
                deployedList.add("Already deployed");
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])deployedList.toArray(new String[0]));
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not deploy JAR file {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

