/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.management.internal.cli.domain.StackTracesPerMember;

public class GetStackTracesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        try {
            Cache cache = context.getCache();
            String memberNameOrId = cache.getDistributedSystem().getDistributedMember().getName();
            if (memberNameOrId == null) {
                memberNameOrId = cache.getDistributedSystem().getDistributedMember().getId();
            }
            StackTracesPerMember stackTracePerMember = new StackTracesPerMember(memberNameOrId, OSProcess.zipStacks());
            context.getResultSender().lastResult(stackTracePerMember);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return GetStackTracesFunction.class.getName();
    }
}

