/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.InternalEntity;

public class MemberRegionFunction
implements Function,
InternalEntity {
    public static final String ID = MemberRegionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        Object[] args = (Object[])context.getArguments();
        String region = (String)args[0];
        String functionId = (String)args[1];
        Cache cache = context.getCache();
        try {
            Execution execution;
            Function function = FunctionService.getFunction(functionId);
            if (function == null) {
                context.getResultSender().lastResult("For region on a member did not get function " + functionId);
            }
            if ((execution = FunctionService.onRegion(cache.getRegion(region))) == null) {
                context.getResultSender().lastResult("For region on a member could not execute");
            } else {
                execution.execute(function);
                context.getResultSender().lastResult("succeeded in executing on region " + region);
            }
        }
        catch (FunctionException e) {
            context.getResultSender().lastResult("FunctionException in MemberRegionFunction =" + e.getMessage());
        }
        catch (Exception e) {
            context.getResultSender().lastResult("Exception in MemberRegionFunction =" + e.getMessage());
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

