/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class MembersForRegionFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = MembersForRegionFunction.class.getName();

    public void execute(FunctionContext context) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Cache cache = context.getCache();
            String memberNameOrId = cache.getDistributedSystem().getDistributedMember().getId();
            Object args = context.getArguments();
            String regionName = (String)args;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                resultMap.put(memberNameOrId, "" + region.getAttributes().getScope().isLocal());
            } else {
                String regionWithPrefix = "/" + regionName;
                region = cache.getRegion(regionWithPrefix);
                if (region != null) {
                    resultMap.put(memberNameOrId, "" + region.getAttributes().getScope().isLocal());
                } else {
                    resultMap.put("", "");
                }
            }
            context.getResultSender().lastResult(resultMap);
        }
        catch (Exception ex) {
            logger.info("MembersForRegionFunction exception {}", (Object)ex.getMessage(), (Object)ex);
            resultMap.put("", "");
            context.getResultSender().lastResult(resultMap);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }
}

