/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.ColocatedRegionDetails;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;

public class ShowMissingDiskStoresFunction
extends FunctionAdapter
implements InternalEntity {
    public void execute(FunctionContext context) {
        HashSet<PersistentMemberPattern> memberMissingIDs = new HashSet<PersistentMemberPattern>();
        HashSet<ColocatedRegionDetails> missingColocatedRegions = new HashSet<ColocatedRegionDetails>();
        if (context == null) {
            throw new RuntimeException();
        }
        try {
            InternalCache cache = (InternalCache)context.getCache();
            if (cache != null && !cache.isClosed()) {
                InternalDistributedMember member = cache.getMyId();
                PersistentMemberManager mm = cache.getPersistentMemberManager();
                Map<String, Set<PersistentMemberID>> waitingRegions = mm.getWaitingRegions();
                for (Set<PersistentMemberID> entry : waitingRegions.values()) {
                    for (PersistentMemberID id : entry) {
                        memberMissingIDs.add(new PersistentMemberPattern(id));
                    }
                }
                Set<PartitionedRegion> prs = cache.getPartitionedRegions();
                for (PartitionedRegion pr : prs) {
                    List<String> missingChildRegions = pr.getMissingColocatedChildren();
                    for (String child : missingChildRegions) {
                        missingColocatedRegions.add(new ColocatedRegionDetails(member.getHost(), member.getName(), pr.getFullPath(), child));
                    }
                }
            }
            if (memberMissingIDs.isEmpty() && missingColocatedRegions.isEmpty()) {
                context.getResultSender().lastResult(null);
            } else {
                if (!memberMissingIDs.isEmpty()) {
                    if (missingColocatedRegions.isEmpty()) {
                        context.getResultSender().lastResult(memberMissingIDs);
                    } else {
                        context.getResultSender().sendResult(memberMissingIDs);
                    }
                }
                if (!missingColocatedRegions.isEmpty()) {
                    context.getResultSender().lastResult(missingColocatedRegions);
                }
            }
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }
}

