/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.logging.log4j.Logger;

public class ShutDownFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ShutDownFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        try {
            InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
            if (system == null) {
                return;
            }
            String memberName = system.getDistributedMember().getId();
            logger.info("Received GFSH shutdown. Shutting down member " + memberName);
            this.disconnectInNonDaemonThread(system);
            context.getResultSender().lastResult("SUCCESS: succeeded in shutting down " + memberName);
        }
        catch (Exception ex) {
            logger.warn("Error during shutdown", (Throwable)ex);
            context.getResultSender().lastResult("FAILURE: failed in shutting down " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectInNonDaemonThread(InternalDistributedSystem ids) throws InterruptedException, ExecutionException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<?> future = exec.submit(() -> {
            ConnectionTable.threadWantsSharedResources();
            if (ids.isConnected()) {
                ids.disconnect();
            }
        });
        try {
            future.get();
        }
        finally {
            exec.shutdown();
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

