/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import java.io.IOException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.cli.functions.ExportLogsFunction;
import org.apache.geode.management.internal.cli.util.BytesToString;
import org.apache.geode.management.internal.cli.util.LogExporter;
import org.apache.geode.management.internal.cli.util.LogFilter;
import org.apache.logging.log4j.Logger;

public class SizeExportLogsFunction
extends ExportLogsFunction
implements Function,
InternalEntity {
    private static final Logger LOGGER = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        try {
            InternalCache cache = (InternalCache)context.getCache();
            DistributionConfig config = cache.getInternalDistributedSystem().getConfig();
            ExportLogsFunction.Args args = (ExportLogsFunction.Args)context.getArguments();
            long diskAvailable = this.getDiskAvailable(config);
            long estimatedSize = this.estimateLogFileSize(cache.getMyId(), config.getLogFile(), config.getStatisticArchiveFile(), args);
            BytesToString bytesToString = new BytesToString();
            if (estimatedSize == 0L || estimatedSize < diskAvailable) {
                context.getResultSender().lastResult(estimatedSize);
            } else {
                StringBuilder sb = new StringBuilder().append("Estimated disk space required (").append(bytesToString.of(estimatedSize)).append(") to consolidate logs on member ").append(cache.getName()).append(" will exceed available disk space (").append(bytesToString.of(diskAvailable)).append(")");
                context.getResultSender().sendException(new ManagementException(sb.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            context.getResultSender().sendException(e);
        }
    }

    long getDiskAvailable(DistributionConfig config) {
        return config.getLogFile().getUsableSpace();
    }

    long estimateLogFileSize(DistributedMember member, File logFile, File statArchive, ExportLogsFunction.Args args) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SizeExportLogsFunction started for member {}", (Object)member);
        }
        File baseLogFile = null;
        File baseStatsFile = null;
        if (args.isIncludeLogs() && !logFile.toString().isEmpty()) {
            baseLogFile = logFile.getAbsoluteFile();
        }
        if (args.isIncludeStats() && !statArchive.toString().isEmpty()) {
            baseStatsFile = statArchive.getAbsoluteFile();
        }
        LogFilter logFilter = new LogFilter(args.getLogLevel(), args.isThisLogLevelOnly(), args.getStartTime(), args.getEndTime());
        long estimatedSize = new LogExporter(logFilter, baseLogFile, baseStatsFile).estimateFilteredSize();
        LOGGER.info("Estimated log file size: " + estimatedSize);
        return estimatedSize;
    }
}

