/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GfJsonObject {
    public static final Object NULL = JSONObject.NULL;
    private JSONObject jsonObject;

    public GfJsonObject() {
        this.jsonObject = new JSONObject();
    }

    public GfJsonObject(Object bean, boolean checkCyclicDep) {
        if (checkCyclicDep) {
            JSONObject.cyclicDepChkEnabled.set(true);
            JSONObject.cyclicDependencySet.set(new HashSet());
        }
        this.jsonObject = bean instanceof JSONObject ? (JSONObject)bean : new JSONObject(bean);
        if (checkCyclicDep) {
            JSONObject.cyclicDepChkEnabled.set(false);
            JSONObject.cyclicDependencySet.set(null);
        }
    }

    public GfJsonObject(GfJsonObject gfJsonObject) {
        this.jsonObject = gfJsonObject.jsonObject;
    }

    public GfJsonObject(Map<?, ?> map) {
        this.jsonObject = new JSONObject(map);
    }

    public GfJsonObject(Object bean) {
        this.jsonObject = bean instanceof JSONObject ? (JSONObject)bean : new JSONObject(bean);
    }

    public GfJsonObject(String source) throws GfJsonException {
        try {
            this.jsonObject = new JSONObject(source);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonObject accumulate(String key, Object value) throws GfJsonException {
        try {
            if (this.jsonObject.has(key)) {
                this.jsonObject.append(key, value);
            } else {
                this.jsonObject.put(key, (Object)new JSONArray().put(value));
            }
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject accumulateAsJSONObject(String key, Object value) throws GfJsonException {
        JSONObject val = new JSONObject(value);
        try {
            if (this.jsonObject.has(key)) {
                this.jsonObject.append(key, (Object)val);
            } else {
                this.jsonObject.put(key, (Object)new JSONArray().put((Object)val));
            }
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject append(String key, Object value) throws GfJsonException {
        try {
            this.jsonObject.append(key, value);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public Object get(String key) {
        return this.jsonObject.opt(key);
    }

    public String getString(String key) {
        return this.jsonObject.optString(key);
    }

    public int getInt(String key) {
        return this.jsonObject.optInt(key);
    }

    public long getLong(String key) {
        return this.jsonObject.optLong(key);
    }

    public double getDouble(String key) {
        return this.jsonObject.optDouble(key);
    }

    public boolean getBoolean(String key) {
        return this.jsonObject.optBoolean(key);
    }

    public GfJsonObject getJSONObject(String key) {
        Object opt = this.jsonObject.opt(key);
        if (opt instanceof GfJsonObject) {
            return (GfJsonObject)opt;
        }
        return new GfJsonObject(opt);
    }

    public JSONObject getInternalJsonObject() {
        return this.jsonObject;
    }

    public GfJsonArray getJSONArray(String key) throws GfJsonException {
        JSONArray jsonArray = this.jsonObject.optJSONArray(key);
        if (jsonArray == null) {
            return null;
        }
        return new GfJsonArray(jsonArray);
    }

    public GfJsonArray names() throws GfJsonException {
        GfJsonArray gfJsonArray = new GfJsonArray();
        JSONArray names = this.jsonObject.names();
        if (names != null) {
            gfJsonArray = new GfJsonArray(names);
        }
        return gfJsonArray;
    }

    public GfJsonObject put(String key, Object value) throws GfJsonException {
        try {
            this.jsonObject.put(key, GfJsonObject.extractInternalForGfJsonOrReturnSame(value));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putAsJSONObject(String key, Object value) throws GfJsonException {
        try {
            Object internalJsonObj = GfJsonObject.extractInternalForGfJsonOrReturnSame(value);
            if (internalJsonObj == value) {
                GfJsonObject jsonObj = new GfJsonObject(value);
                internalJsonObj = jsonObj.getInternalJsonObject();
            }
            this.jsonObject.put(key, internalJsonObj);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putOpt(String key, Object value) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key, GfJsonObject.extractInternalForGfJsonOrReturnSame(value));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject put(String key, Collection<?> value) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key, value);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putJSONArray(String key, GfJsonArray value) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key, (Object)value.getInternalJsonArray());
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject put(String key, Map<?, ?> value) throws GfJsonException {
        try {
            this.jsonObject.put(key, value);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public static String quote(String string) {
        return JSONObject.quote((String)string);
    }

    public Object remove(String key) {
        return this.jsonObject.remove(key);
    }

    public boolean has(String key) {
        return this.jsonObject.has(key);
    }

    public Iterator<String> keys() {
        return this.jsonObject.keys();
    }

    public int size() {
        return this.jsonObject.length();
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public String getType() {
        return this.jsonObject.optString("type-class");
    }

    public String toIndentedString(int indentFactor) throws GfJsonException {
        try {
            return this.jsonObject.toString(indentFactor);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    private static Object extractInternalForGfJsonOrReturnSame(Object value) {
        Object returnedValue = value;
        if (value instanceof GfJsonObject) {
            returnedValue = ((GfJsonObject)value).getInternalJsonObject();
        } else if (value instanceof GfJsonArray) {
            returnedValue = ((GfJsonArray)value).getInternalJsonArray();
        } else if (value == null) {
            returnedValue = NULL;
        }
        return returnedValue;
    }

    public static GfJsonObject getGfJsonErrorObject(String errorMessage) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("error", errorMessage);
        return new GfJsonObject(errorMap);
    }

    public static boolean isJSONKind(Object object) {
        return object instanceof JSONObject;
    }
}

