/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.ReflectionUtils;

public class CommandExecutor {
    private Logger logger = LogService.getLogger();

    public Object execute(ParseResult parseResult) {
        try {
            Object result = this.invokeCommand(parseResult);
            if (result == null) {
                return ResultBuilder.createGemFireErrorResult("Command returned null: " + parseResult);
            }
            return result;
        }
        catch (NotAuthorizedException e) {
            this.logger.error("Not authorized to execute \"" + parseResult + "\".", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Could not execute \"" + parseResult + "\".", (Throwable)e);
            return ResultBuilder.createGemFireErrorResult("Error while processing command <" + parseResult + "> Reason : " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected Object invokeCommand(ParseResult parseResult) {
        return ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)parseResult.getInstance(), (Object[])parseResult.getArguments());
    }
}

