/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TableBuilder;

public class CommandResult
implements Result {
    private GfJsonObject gfJsonObject;
    private Result.Status status;
    private int index;
    private boolean isDataBuilt;
    private ResultData resultData;
    private List<String> resultLines;
    private boolean failedToPersist = false;
    private transient int numTimesSaved;
    private Path fileToDownload;

    public Path getFileToDownload() {
        return this.fileToDownload;
    }

    public CommandResult(ResultData resultData) {
        this.resultData = resultData;
        this.gfJsonObject = this.resultData.getGfJsonObject();
        this.status = this.resultData.getStatus();
        this.resultLines = new Vector<String>();
    }

    public CommandResult(Path fileToDownload) {
        this(new InfoResultData(fileToDownload.toString()));
        this.fileToDownload = fileToDownload.toAbsolutePath();
    }

    public boolean hasFileToDownload() {
        return this.fileToDownload != null;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }

    public ResultData getResultData() {
        return ResultBuilder.getReadOnlyResultData(this.resultData);
    }

    GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public void resetToFirstLine() {
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildData() {
        try {
            if ("object".equals(this.resultData.getType())) {
                this.buildObjectResultOutput();
            } else if ("composite".equals(this.resultData.getType())) {
                this.buildComposite();
            } else {
                GfJsonObject content = this.getContent();
                if (content != null) {
                    TableBuilder.Table resultTable = TableBuilder.newTable();
                    this.addHeaderInTable(resultTable, this.getGfJsonObject());
                    TableBuilder.RowGroup rowGroup = resultTable.newRowGroup();
                    if ("table".equals(this.resultData.getType())) {
                        resultTable.setColumnSeparator("   ");
                        resultTable.setTabularResult(true);
                        this.buildTable(rowGroup, content);
                    } else {
                        this.buildInfoErrorData(rowGroup, content);
                    }
                    this.addFooterInTable(resultTable, this.getGfJsonObject());
                    this.resultLines.addAll(resultTable.buildTableList());
                }
            }
        }
        catch (GfJsonException e) {
            this.resultLines.add("Error occurred while processing Command Result. Internal Error - Invalid Result.");
        }
        finally {
            this.isDataBuilt = true;
        }
    }

    private void addHeaderInTable(TableBuilder.Table resultTable, GfJsonObject fromJsonObject) {
        String header = this.getHeader(fromJsonObject);
        if (header != null && !header.isEmpty()) {
            resultTable.newRow().newLeftCol(header);
        }
    }

    private void addHeaderInRowGroup(TableBuilder.RowGroup rowGroup, GfJsonObject fromJsonObject) {
        String header = this.getHeader(fromJsonObject);
        if (header != null && !header.isEmpty()) {
            rowGroup.newRow().newLeftCol(header);
        }
    }

    private void addFooterInTable(TableBuilder.Table resultTable, GfJsonObject fromJsonObject) {
        String footer = this.getFooter(fromJsonObject);
        if (footer != null && !footer.isEmpty()) {
            resultTable.newRow().newLeftCol(footer);
        }
    }

    private void addFooterInRowGroup(TableBuilder.RowGroup rowGroup, GfJsonObject fromJsonObject) {
        String footer = this.getFooter(fromJsonObject);
        if (footer != null && !footer.isEmpty()) {
            rowGroup.newRow().newLeftCol(footer);
        }
    }

    private void buildInfoErrorData(TableBuilder.RowGroup rowGroup, GfJsonObject content) throws GfJsonException {
        GfJsonArray accumulatedData = content.getJSONArray("message");
        if (accumulatedData != null) {
            this.buildRows(rowGroup, null, accumulatedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildObjectResultOutput() {
        try {
            TableBuilder.Table resultTable = TableBuilder.newTable();
            resultTable.setColumnSeparator(" : ");
            this.addHeaderInTable(resultTable, this.getGfJsonObject());
            GfJsonObject content = this.getContent();
            GfJsonArray objectsArray = content.getJSONArray("__objects__");
            if (objectsArray != null) {
                int numOfObjects = objectsArray.size();
                for (int i = 0; i < numOfObjects; ++i) {
                    GfJsonObject object = objectsArray.getJSONObject(i);
                    this.buildObjectSection(resultTable, null, object, 0);
                }
            }
            this.addFooterInTable(resultTable, this.getGfJsonObject());
            this.resultLines.addAll(resultTable.buildTableList());
        }
        catch (GfJsonException e) {
            this.resultLines.add("Error occurred while processing Command Result. Internal Error - Invalid Result.");
        }
        finally {
            this.isDataBuilt = true;
        }
    }

    private void buildObjectSection(TableBuilder.Table table, TableBuilder.RowGroup parentRowGroup, GfJsonObject object, int depth) throws GfJsonException {
        Iterator<String> keys = object.keys();
        TableBuilder.RowGroup rowGroup = parentRowGroup != null ? parentRowGroup : table.newRowGroup();
        GfJsonArray nestedCollection = null;
        GfJsonObject nestedObject = null;
        GfJsonObject fieldDisplayNames = object.getJSONObject("fieldNameToDisplayName");
        ArrayList<String> fieldsToSkipOnUI = null;
        if (object.has("fieldsToSkipOnUI")) {
            GfJsonArray jsonArray = object.getJSONArray("fieldsToSkipOnUI");
            fieldsToSkipOnUI = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                fieldsToSkipOnUI.add(String.valueOf(jsonArray.get(i)));
            }
        }
        while (keys.hasNext()) {
            String key = keys.next();
            if ("fieldNameToDisplayName, JSId, outputFormat, fieldsToSkipOnUI".contains(key) || fieldsToSkipOnUI != null && fieldsToSkipOnUI.contains(key)) continue;
            try {
                nestedCollection = object.getJSONArray(key);
            }
            catch (GfJsonException i) {
                // empty catch block
            }
            Object field = null;
            if (nestedCollection == null && !this.isPrimitiveOrStringOrWrapper(field = object.get(key))) {
                nestedObject = object.getJSONObject(key);
            }
            if (nestedCollection != null && this.isPrimitiveOrStringOrWrapperArray(nestedCollection)) {
                String str = nestedCollection.toString();
                field = str.substring(1, str.length() - 1);
                nestedCollection = null;
            }
            TableBuilder.Row newRow = rowGroup.newRow();
            String prefix = "";
            for (int i = 0; i < depth; ++i) {
                prefix = prefix + " . ";
            }
            String fieldNameToDisplay = fieldDisplayNames.getString(key);
            if (nestedCollection == null) {
                newRow.newLeftCol(prefix + fieldNameToDisplay);
            }
            if (nestedCollection != null) {
                HashMap<String, Integer> columnsMap = new HashMap<String, Integer>();
                TableBuilder.RowGroup newRowGroup = table.newRowGroup();
                newRowGroup.setColumnSeparator(" | ");
                newRowGroup.newBlankRow();
                newRowGroup.newRow().newLeftCol(fieldNameToDisplay);
                TableBuilder.Row headerRow = newRowGroup.newRow();
                int numOfRows = nestedCollection.size();
                ArrayList<String> tableFieldsToSkipOnUI = null;
                for (int j = 0; j < numOfRows; ++j) {
                    GfJsonObject content = nestedCollection.getJSONObject(j);
                    if (content.has("fieldsToSkipOnUI")) {
                        GfJsonArray jsonArray = content.getJSONArray("fieldsToSkipOnUI");
                        tableFieldsToSkipOnUI = new ArrayList<String>();
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            tableFieldsToSkipOnUI.add(String.valueOf(jsonArray.get(i)));
                        }
                    }
                    GfJsonArray columnNames = content.names();
                    int numOfColumns = columnNames.size();
                    if (headerRow.isEmpty()) {
                        GfJsonObject innerFieldDisplayNames = content.getJSONObject("fieldNameToDisplayName");
                        for (int i = 0; i < numOfColumns; ++i) {
                            Object columnName = columnNames.get(i);
                            if ("fieldNameToDisplayName, JSId, outputFormat, fieldsToSkipOnUI".contains((String)columnName) || tableFieldsToSkipOnUI != null && tableFieldsToSkipOnUI.contains(columnName)) continue;
                            headerRow.newCenterCol(innerFieldDisplayNames.getString((String)columnName));
                            columnsMap.put((String)columnName, i);
                        }
                        newRowGroup.newRowSeparator(Character.valueOf('-'), false);
                    }
                    newRow = newRowGroup.newRow();
                    for (int i = 0; i < numOfColumns; ++i) {
                        Object columnName = columnNames.get(i);
                        if ("fieldNameToDisplayName, JSId, outputFormat, fieldsToSkipOnUI".contains((String)columnName) || tableFieldsToSkipOnUI != null && tableFieldsToSkipOnUI.contains(columnName)) continue;
                        newRow.newLeftCol(String.valueOf(content.get((String)columnName)));
                    }
                }
            } else if (nestedObject != null) {
                this.buildObjectSection(table, rowGroup, nestedObject, depth + 1);
            } else {
                newRow.newLeftCol(field);
            }
            nestedCollection = null;
            nestedObject = null;
        }
    }

    private boolean isPrimitiveOrStringOrWrapper(Object object) {
        boolean isPrimitive = false;
        if (String.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Byte.TYPE.isInstance(object) || Byte.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Short.TYPE.isInstance(object) || Short.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Integer.TYPE.isInstance(object) || Integer.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Long.TYPE.isInstance(object) || Long.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Float.TYPE.isInstance(object) || Float.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Double.TYPE.isInstance(object) || Double.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Boolean.TYPE.isInstance(object) || Boolean.class.isInstance(object)) {
            isPrimitive = true;
        } else if (Character.TYPE.isInstance(object) || Character.class.isInstance(object)) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    private boolean isPrimitiveOrStringOrWrapperArray(Object object) {
        boolean isPrimitive = false;
        if (String[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (byte[].class.isInstance(object) || Byte[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (short[].class.isInstance(object) || Short[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (int[].class.isInstance(object) || Integer[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (long[].class.isInstance(object) || Long[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (float[].class.isInstance(object) || Float[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (double[].class.isInstance(object) || Double[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (boolean[].class.isInstance(object) || Boolean[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (char[].class.isInstance(object) || Character[].class.isInstance(object)) {
            isPrimitive = true;
        } else if (GfJsonArray.class.isInstance(object)) {
            GfJsonArray jsonArr = (GfJsonArray)object;
            try {
                isPrimitive = this.isPrimitiveOrStringOrWrapper(jsonArr.get(0));
            }
            catch (GfJsonException gfJsonException) {
                // empty catch block
            }
        }
        return isPrimitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildComposite() {
        try {
            GfJsonObject content = this.getContent();
            if (content != null) {
                TableBuilder.Table resultTable = TableBuilder.newTable();
                resultTable.setColumnSeparator(" : ");
                this.addHeaderInTable(resultTable, this.getGfJsonObject());
                Iterator<String> it = content.keys();
                while (it.hasNext()) {
                    String key = it.next();
                    if (key.startsWith("__sections__")) {
                        GfJsonObject subSection = content.getJSONObject(key);
                        this.buildSection(resultTable, null, subSection, 0);
                        continue;
                    }
                    if (!key.equals(CompositeResultData.SEPARATOR)) continue;
                    String separatorString = content.getString(key);
                    resultTable.newRowGroup().newRowSeparator(Character.valueOf(separatorString.charAt(0)), true);
                }
                this.addFooterInTable(resultTable, this.getGfJsonObject());
                this.resultLines.addAll(resultTable.buildTableList());
            }
        }
        catch (GfJsonException e) {
            this.resultLines.add("Error occurred while processing Command Result. Internal Error - Invalid Result.");
            LogWrapper.getInstance().info("Error occurred while processing Command Result. Internal Error - Invalid Result.", e);
        }
        finally {
            this.isDataBuilt = true;
        }
    }

    private void buildSection(TableBuilder.Table table, TableBuilder.RowGroup parentRowGroup, GfJsonObject section, int depth) throws GfJsonException {
        Iterator<String> keys = section.keys();
        TableBuilder.RowGroup rowGroup = parentRowGroup != null ? parentRowGroup : table.newRowGroup();
        this.addHeaderInRowGroup(rowGroup, section);
        while (keys.hasNext()) {
            String key = keys.next();
            Object object = section.get(key);
            if (key.startsWith("__tables__")) {
                GfJsonObject tableObject = section.getJSONObject(key);
                this.addHeaderInTable(table, tableObject);
                TableBuilder.RowGroup rowGroupForTable = table.newRowGroup();
                this.buildTable(rowGroupForTable, tableObject.getJSONObject("content"));
                this.addFooterInTable(table, tableObject);
                continue;
            }
            if (key.startsWith("__sections__")) {
                GfJsonObject subSection = section.getJSONObject(key);
                this.buildSection(table, rowGroup, subSection, depth + 1);
                continue;
            }
            if (key.equals(CompositeResultData.SEPARATOR)) {
                String separatorString = section.getString(key);
                rowGroup.newRowSeparator(Character.valueOf(separatorString.charAt(0)), true);
                continue;
            }
            if (key.equals("header") || key.equals("footer")) continue;
            TableBuilder.Row newRow = rowGroup.newRow();
            String prefix = "";
            for (int i = 0; i < depth; ++i) {
                prefix = prefix + " . ";
            }
            String[] value = CommandResult.getValuesSeparatedByLines(object);
            if (value.length == 1) {
                newRow.newLeftCol(prefix + key).newLeftCol(value[0]);
                continue;
            }
            if (value.length != 0) {
                newRow.newLeftCol(prefix + key).newLeftCol(value[0]);
                for (int i = 1; i < value.length; ++i) {
                    newRow = rowGroup.newRow();
                    newRow.setColumnSeparator("   ");
                    newRow.newLeftCol("").newLeftCol(value[i]);
                }
                continue;
            }
            newRow.newLeftCol(prefix + key).newLeftCol("");
        }
        this.addFooterInRowGroup(rowGroup, section);
    }

    private static String[] getValuesSeparatedByLines(Object object) {
        String valueString = String.valueOf(object);
        return valueString.split(GfshParser.LINE_SEPARATOR);
    }

    private void buildTable(TableBuilder.RowGroup rowGroup, GfJsonObject content) throws GfJsonException {
        GfJsonArray columnNames = content.names();
        int numOfColumns = columnNames.size();
        TableBuilder.Row headerRow = rowGroup.newRow();
        rowGroup.setColumnSeparator(" | ");
        rowGroup.newRowSeparator(Character.valueOf('-'), false);
        for (int i = 0; i < numOfColumns; ++i) {
            Object object = columnNames.get(i);
            if ("__bytes__".equals(object)) continue;
            headerRow.newCenterCol(object);
        }
        TableBuilder.Row[] dataRows = null;
        for (int i = 0; i < numOfColumns; ++i) {
            Object object = columnNames.get(i);
            if ("__bytes__".equals(object)) continue;
            GfJsonArray accumulatedData = content.getJSONArray((String)object);
            dataRows = this.buildRows(rowGroup, dataRows, accumulatedData);
        }
    }

    private TableBuilder.Row[] buildRows(TableBuilder.RowGroup rowGroup, TableBuilder.Row[] dataRows, GfJsonArray accumulatedData) throws GfJsonException {
        int j;
        int size = accumulatedData.size();
        if (dataRows == null) {
            dataRows = new TableBuilder.Row[size];
            for (j = 0; j < dataRows.length; ++j) {
                dataRows[j] = rowGroup.newRow();
            }
        }
        for (j = 0; j < size; ++j) {
            dataRows[j].newLeftCol(accumulatedData.get(j));
        }
        return dataRows;
    }

    @Override
    public boolean hasIncomingFiles() {
        GfJsonArray fileDataArray = null;
        try {
            GfJsonObject content = this.getContent();
            if (content != null) {
                fileDataArray = content.getJSONArray("__bytes__");
            }
        }
        catch (GfJsonException e) {
            e.printStackTrace();
        }
        return fileDataArray != null;
    }

    public int getNumTimesSaved() {
        return this.numTimesSaved;
    }

    @Override
    public void saveIncomingFiles(String directory) throws IOException {
        try {
            GfJsonObject content = this.getContent();
            if (content == null) {
                throw new RuntimeException("No associated files to save .. ");
            }
            GfJsonArray bytesArray = content.getJSONArray("__bytes__");
            AbstractResultData.readFileDataAndDump(bytesArray, directory);
            ++this.numTimesSaved;
        }
        catch (DataFormatException | GfJsonException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNextLine() {
        if (!this.isDataBuilt) {
            this.buildData();
        }
        return this.index < this.resultLines.size();
    }

    @Override
    public String nextLine() {
        if (!this.isDataBuilt) {
            this.buildData();
        }
        return this.resultLines.get(this.index++);
    }

    public String toJson() {
        return this.gfJsonObject.toString();
    }

    public String getType() {
        return this.resultData.getType();
    }

    public String getHeader() {
        return this.getHeader(this.gfJsonObject);
    }

    public String getHeader(GfJsonObject gfJsonObject) {
        return gfJsonObject.getString("header");
    }

    public GfJsonObject getContent() {
        return this.gfJsonObject.getJSONObject("content");
    }

    public String getFooter() {
        return this.getFooter(this.gfJsonObject);
    }

    public String getFooter(GfJsonObject gfJsonObject) {
        return gfJsonObject.getString("footer");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommandResult)) {
            return false;
        }
        CommandResult other = (CommandResult)obj;
        return this.gfJsonObject.toString().equals(other.gfJsonObject.toString());
    }

    public int hashCode() {
        return this.gfJsonObject.hashCode();
    }

    public String toString() {
        return "CommandResult [gfJsonObject=" + this.gfJsonObject + ", status=" + (Object)((Object)this.status) + ", index=" + this.index + ", isDataBuilt=" + this.isDataBuilt + ", resultData=" + this.resultData + ", resultLines=" + this.resultLines + ", failedToPersist=" + this.failedToPersist + "]";
    }

    @Override
    public boolean failedToPersist() {
        return this.failedToPersist;
    }

    @Override
    public void setCommandPersisted(boolean commandPersisted) {
        this.failedToPersist = !commandPersisted;
    }

    public void setFileToDownload(Path fileToDownload) {
        this.fileToDownload = fileToDownload;
    }
}

