/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.xml.sax.SAXException;

public class ConfigurationResponse
implements DataSerializableFixedID {
    private Map<String, Configuration> requestedConfiguration = new HashMap<String, Configuration>();
    private byte[][] jarBytes;
    private String[] jarNames;
    private boolean failedToGetSharedConfig = false;

    public ConfigurationResponse() {
    }

    public ConfigurationResponse(Map<String, Configuration> requestedConfiguration) {
        this.requestedConfiguration.putAll(requestedConfiguration);
    }

    @Override
    public int getDSFID() {
        return 2160;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashMap((HashMap)this.requestedConfiguration, out);
        DataSerializer.writeStringArray(this.jarNames, out);
        DataSerializer.writeArrayOfByteArrays(this.jarBytes, out);
        DataSerializer.writeBoolean(this.failedToGetSharedConfig, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.requestedConfiguration = DataSerializer.readHashMap(in);
        this.jarNames = DataSerializer.readStringArray(in);
        this.jarBytes = DataSerializer.readArrayOfByteArrays(in);
        this.failedToGetSharedConfig = DataSerializer.readBoolean(in);
    }

    public Map<String, Configuration> getRequestedConfiguration() {
        return this.requestedConfiguration;
    }

    public void setRequestedConfiguration(Map<String, Configuration> requestedConfiguration) {
        this.requestedConfiguration = requestedConfiguration;
    }

    public void addConfiguration(Configuration configuration) {
        if (configuration != null) {
            this.requestedConfiguration.put(configuration.getConfigName(), configuration);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> configNames = this.requestedConfiguration.keySet();
        for (String configName : configNames) {
            sb.append("\n" + this.requestedConfiguration.get(configName));
        }
        return sb.toString();
    }

    public String describeConfig() {
        StringBuffer sb = new StringBuffer();
        if (this.requestedConfiguration.isEmpty()) {
            sb.append("Received an empty shared configuration");
        } else {
            Set<Map.Entry<String, Configuration>> entries = this.requestedConfiguration.entrySet();
            for (Map.Entry<String, Configuration> entry : entries) {
                String configType = entry.getKey();
                Configuration config = entry.getValue();
                if (config == null) continue;
                sb.append("\n***************************************************************");
                sb.append("\nConfiguration for  '" + configType + "'");
                sb.append("\n\nJar files to deployed");
                Set<String> jarNames = config.getJarNames();
                Iterator<String> jarIter = jarNames.iterator();
                int jarCounter = 0;
                while (jarIter.hasNext()) {
                    sb.append("\n" + ++jarCounter + "." + jarIter.next());
                }
                try {
                    String cacheXmlContent = config.getCacheXmlContent();
                    if (!StringUtils.isNotBlank((String)cacheXmlContent)) continue;
                    sb.append("\n" + XmlUtils.prettyXml(cacheXmlContent));
                }
                catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
                    throw new InternalGemFireError(e);
                }
            }
        }
        return sb.toString();
    }

    public String[] getJarNames() {
        return this.jarNames;
    }

    public byte[][] getJars() {
        return this.jarBytes;
    }

    public void addJarsToBeDeployed(String[] jarNames, byte[][] jarBytes) {
        this.jarNames = jarNames;
        this.jarBytes = jarBytes;
    }

    @Override
    public Version[] getSerializationVersions() {
        return new Version[]{Version.CURRENT};
    }

    public boolean failedToGetSharedConfig() {
        return this.failedToGetSharedConfig;
    }

    public void setFailedToGetSharedConfig(boolean failedToGetSharedConfig) {
        this.failedToGetSharedConfig = failedToGetSharedConfig;
    }
}

