/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class IncrByExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "The value at this key cannot be incremented numerically";
    private final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be numeric";
    private final String ERROR_OVERFLOW = "This incrementation cannot be performed due to overflow";
    private final int INCREMENT_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Long value;
        Long increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the INCRBY command is \"INCRBY key increment\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper valueWrapper = r.get(key);
        byte[] incrArray = commandElems.get(2);
        try {
            increment = Coder.bytesToLong(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The increment on this key must be numeric"));
            return;
        }
        if (valueWrapper == null) {
            r.put(key, new ByteArrayWrapper(incrArray));
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), increment));
            return;
        }
        String stringValue = Coder.bytesToString(valueWrapper.toBytes());
        try {
            value = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this key cannot be incremented numerically"));
            return;
        }
        if (value >= 0L && increment > Long.MAX_VALUE - value) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This incrementation cannot be performed due to overflow"));
            return;
        }
        value = value + increment;
        stringValue = "" + value;
        r.put(key, new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

