/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class SetNXExecutor
extends StringExecutor {
    private final int SET = 1;
    private final int NOT_SET = 0;
    private final int VALUE_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SETNX command is \"SETNX key value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        byte[] value = commandElems.get(2);
        ByteArrayWrapper oldValue = r.putIfAbsent(key, new ByteArrayWrapper(value));
        if (oldValue != null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        }
    }
}

