/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.Principal;
import javax.naming.NamingException;
import org.apache.geode.security.GemFireSecurityException;

public class NotAuthorizedException
extends GemFireSecurityException {
    private static final long serialVersionUID = 419215768216387745L;
    private Principal principal = null;

    public NotAuthorizedException(String message) {
        this(message, null, null);
    }

    public NotAuthorizedException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public NotAuthorizedException(String message, Principal principal) {
        this(message, null, principal);
    }

    public NotAuthorizedException(String message, Throwable cause, Principal principal) {
        super(message, cause);
        this.principal = principal;
    }

    public synchronized Principal getPrincipal() {
        return this.principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Principal thisPrincipal = this.principal;
        if (!this.isSerializable(thisPrincipal)) {
            this.principal = null;
        }
        Object resolvedObj = this.getResolvedObj();
        NamingException namingException = null;
        if (!this.isSerializable(resolvedObj)) {
            namingException = (NamingException)this.getCause();
            namingException.setResolvedObj(null);
        }
        try {
            out.defaultWriteObject();
        }
        finally {
            this.principal = thisPrincipal;
            if (namingException != null) {
                namingException.setResolvedObj(resolvedObj);
            }
        }
    }
}

