/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class QRegion
implements SelectResults {
    private final Region region;
    private final SelectResults values;

    public QRegion(Region region, boolean includeKeys) {
        if (region == null) {
            throw new IllegalArgumentException(LocalizedStrings.QRegion_REGION_CAN_NOT_BE_NULL.toLocalizedString());
        }
        this.region = region;
        Class<Object> constraint = this.region.getAttributes().getValueConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        ResultsCollectionWrapper res = null;
        res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), this.region.entrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), this.region.values());
        res.setModifiable(false);
        if (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL) {
            res.setIgnoreCopyOnReadForQuery(true);
        }
        this.values = res;
    }

    public QRegion(Region region, boolean includeKeys, ExecutionContext context) {
        if (region == null) {
            throw new IllegalArgumentException(LocalizedStrings.QRegion_REGION_CAN_NOT_BE_NULL.toLocalizedString());
        }
        Class<Object> constraint = region.getAttributes().getValueConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        ResultsCollectionWrapper res = null;
        if (context.getBucketList() != null && region instanceof PartitionedRegion) {
            LocalDataSet localData = new LocalDataSet((PartitionedRegion)region, new HashSet<Integer>(context.getBucketList()));
            this.region = localData;
            res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), localData.localEntrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), localData.localValues());
        } else {
            this.region = region;
            res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), region.entrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), region.values());
        }
        res.setModifiable(false);
        if (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL) {
            res.setIgnoreCopyOnReadForQuery(true);
        }
        this.values = res;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setKeepSerialized(boolean keepSerialized) {
        ((ResultsCollectionWrapper)this.values).setKeepSerialized(keepSerialized);
    }

    protected ObjectType getKeyType() {
        Class<Object> constraint = this.region.getAttributes().getKeyConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        return TypeUtils.getObjectType(constraint);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.values.setElementType(elementType);
    }

    public SelectResults getKeys() {
        ResultsCollectionWrapper res;
        if (this.region instanceof LocalDataSet) {
            LocalDataSet localData = (LocalDataSet)this.region;
            res = new ResultsCollectionWrapper(this.getKeyType(), localData.localKeys());
        } else {
            res = new ResultsCollectionWrapper(this.getKeyType(), this.region.keySet());
        }
        res.setModifiable(false);
        return res;
    }

    public Collection values() {
        return this;
    }

    public SelectResults getValues() {
        return this;
    }

    public SelectResults getEntries() {
        ResultsCollectionWrapper res;
        if (this.region instanceof LocalDataSet) {
            LocalDataSet localData = (LocalDataSet)this.region;
            res = new ResultsCollectionWrapper(TypeUtils.getRegionEntryType(this.region), localData.localEntrySet());
        } else {
            res = new ResultsCollectionWrapper(TypeUtils.getRegionEntryType(this.region), this.region.entrySet(false));
        }
        res.setModifiable(false);
        return res;
    }

    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    public int occurrences(Object element) {
        int count = 0;
        for (Object v : this.values) {
            if (!(element == null ? v == null : element.equals(v))) continue;
            ++count;
        }
        return count;
    }

    public List asList() {
        return new ArrayList(this.values);
    }

    public Set asSet() {
        return new HashSet(this.values);
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(QRegion.class, this.values.getCollectionType().getElementType());
    }

    @Override
    public boolean add(Object obj) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.values.contains(obj);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.values.containsAll(collection);
    }

    @Override
    public Iterator iterator() {
        return this.values.iterator();
    }

    public void becomeLockGrantor() {
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public Object[] toArray(Object[] obj) {
        return this.values.toArray(obj);
    }

    public boolean containsKey(Object key) {
        return this.region.containsKey(key);
    }

    public boolean containsValueForKey(Object key) {
        return this.region.containsValueForKey(key);
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.region.create(key, value);
    }

    public void create(Object key, Object value, Object aCacheWriterParam) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.region.create(key, value, aCacheWriterParam);
    }

    public Region createSubregion(String subregionName, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.region.createSubregion(subregionName, aRegionAttributes);
    }

    public void destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        this.region.destroy(key);
    }

    public void destroy(Object key, Object aCacheWriterParam) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        this.region.destroy(key, aCacheWriterParam);
    }

    public void destroyRegion() throws CacheWriterException, TimeoutException {
        this.region.destroyRegion();
    }

    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        this.region.destroyRegion(aCallbackArgument);
    }

    public Set entrySet(boolean recursive) {
        return this.region.entrySet(recursive);
    }

    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.existsValue(queryPredicate);
    }

    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        return this.region.get(key);
    }

    public Object get(Object key, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        return this.region.get(key, aCallbackArgument);
    }

    public RegionAttributes getAttributes() {
        return this.region.getAttributes();
    }

    public AttributesMutator getAttributesMutator() {
        return this.region.getAttributesMutator();
    }

    public Cache getCache() {
        return this.region.getCache();
    }

    public Lock getDistributedLock(Object key) throws IllegalStateException {
        return this.region.getDistributedLock(key);
    }

    public Region.Entry getEntry(Object key) {
        return this.region.getEntry(key);
    }

    public String getFullPath() {
        return this.region.getFullPath();
    }

    public String getName() {
        return this.region.getName();
    }

    public Region getParentRegion() {
        return this.region.getParentRegion();
    }

    public Lock getRegionDistributedLock() throws IllegalStateException {
        return this.region.getRegionDistributedLock();
    }

    public CacheStatistics getStatistics() {
        return this.region.getStatistics();
    }

    public Region getSubregion(String path) {
        return this.region.getSubregion(path);
    }

    public Object getUserAttribute() {
        return this.region.getUserAttribute();
    }

    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        this.region.invalidate(key);
    }

    public void invalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.region.invalidate(key, aCallbackArgument);
    }

    public void invalidateRegion() throws TimeoutException {
        this.region.invalidateRegion();
    }

    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        this.region.invalidateRegion(aCallbackArgument);
    }

    public boolean isDestroyed() {
        return this.region.isDestroyed();
    }

    public Set keys() {
        return this.region.keySet();
    }

    public void localDestroy(Object key) throws EntryNotFoundException {
        this.region.localDestroy(key);
    }

    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        this.region.localDestroy(key, aCallbackArgument);
    }

    public void localDestroyRegion() {
        this.region.localDestroyRegion();
    }

    public void localDestroyRegion(Object aCallbackArgument) {
        this.region.localDestroyRegion(aCallbackArgument);
    }

    public void close() {
        this.region.close();
    }

    public void localInvalidate(Object key) throws EntryNotFoundException {
        this.region.localInvalidate(key);
    }

    public void localInvalidate(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        this.region.localInvalidate(key, aCallbackArgument);
    }

    public void localInvalidateRegion() {
        this.region.localInvalidateRegion();
    }

    public void localInvalidateRegion(Object aCallbackArgument) {
        this.region.localInvalidateRegion(aCallbackArgument);
    }

    public void put(Object key, Object value) throws TimeoutException, CacheWriterException {
        this.region.put(key, value);
    }

    public void put(Object key, Object value, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        this.region.put(key, value, aCallbackArgument);
    }

    public SelectResults query(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.query(predicate);
    }

    public Object selectValue(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.selectValue(predicate);
    }

    public void setUserAttribute(Object value) {
        this.region.setUserAttribute(value);
    }

    public Set subregions(boolean recursive) {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        this.region.loadSnapshot(inputStream);
    }

    public void saveSnapshot(OutputStream outputStream) throws IOException {
        this.region.saveSnapshot(outputStream);
    }

    public void registerInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestListRegex() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public String toString() {
        return this.region.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.values.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean containsValue(Object arg0) {
        return this.region.containsValue(arg0);
    }

    public void putAll(Map arg0) {
        this.region.putAll(arg0);
    }

    public SelectResults entrySet() {
        ResultsCollectionWrapper res = new ResultsCollectionWrapper(new ObjectTypeImpl(Map.Entry.class), this.region.entrySet(false));
        res.setModifiable(false);
        return res;
    }

    public Set keySet() {
        return this.region.keySet();
    }
}

